/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.AttachmentReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyAuditSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyDetailsSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyDetailsUpdateReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyQuotaItemSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyQuotaSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplySaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyUpdateReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditBatchQuotaItemSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditDownBatchSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditDownSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRecordBatchSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountModuleRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditApplyDetailRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditApplyDownAccountRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditApplyDownEntityRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditApplyPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditApplyStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditApplyTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditDownStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageRecordType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.QuotaTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.CreditNoUtil;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.IAttachmentService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditApplyDetailService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditApplyService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditEntityService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditRecordService;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.AttachmentDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditApplyDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditApplyDetailDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDetailDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditTermModelDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.PolicyDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditApplyDetailEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditApplyEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditEntityDetailEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditEntityEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRecordEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditTermModelEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditApplyDetailEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditEntityDetailEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditEntityEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditRecordEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="creditApply")
public class CreditApplyServiceImpl
implements ICreditApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private CreditApplyDas creditApplyDas;
    @Resource
    private CreditTermModelDas creditTermModelDas;
    @Resource
    private CreditEntityDetailDas creditEntityDetailDas;
    @Resource
    private PolicyDas policyDas;
    @Autowired
    private CreditApplyDetailDas creditApplyDetailDas;
    @Autowired
    private IContext iContext;
    @Autowired
    private ICreditAccountService iCreditAccountService;
    @Autowired
    private IAttachmentService iAttachmentService;
    @Autowired
    private CreditEntityDas creditEntityDas;
    @Autowired
    private CreditRecordDas creditRecordDas;
    @Autowired
    private ICreditRecordService iCreditRecordService;
    @Autowired
    private AttachmentDas attachmentDas;
    @Autowired
    private CreditAccountDas creditAccountDas;
    @Autowired
    private ICreditApplyDetailService iCreditApplyDetailService;
    @Autowired
    private ICreditEntityService icreditEntityService;
    @Resource
    private ICreditAccountService creditAccountService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addReturn(CreditApplySaveReqDto creditApplySaveReqDto) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        Date date = new Date();
        CreditApplyEo creditApplyEo = new CreditApplyEo();
        creditApplyEo.setApplyPerson(StringUtils.isEmpty((Object)creditApplySaveReqDto.getApplyPerson()) ? this.iContext.userName() : creditApplySaveReqDto.getApplyPerson());
        creditApplyEo.setApplyTime(new Date());
        creditApplyEo.setApprovePerson(null);
        creditApplyEo.setExtension(creditApplySaveReqDto.getExtension());
        creditApplyEo.setQuotaType(creditApplySaveReqDto.getQuotaType());
        creditApplyEo.setApproveNo(CreditNoUtil.generateTradeNo((String)CreditApplyTypeEnum.SXSQ.getName()));
        creditApplyEo.setReason(creditApplySaveReqDto.getReason());
        creditApplyEo.setRemark(creditApplySaveReqDto.getRemark());
        creditApplyEo.setCreditApplyStatus(CreditApplyStatusEnum.WAIT.getCode());
        creditApplyEo.setOrgInfoId(orgId);
        this.creditApplyDas.insert((BaseEo)creditApplyEo);
        List applyDetails = creditApplySaveReqDto.getApplyDetails();
        ArrayList<CreditApplyDetailEo> list = new ArrayList<CreditApplyDetailEo>();
        for (CreditApplyDetailsSaveReqDto applyDetail : applyDetails) {
            CreditApplyDetailEo creditApplyDetailEo = new CreditApplyDetailEo();
            creditApplyDetailEo.setCreditApplyId(creditApplyEo.getId());
            creditApplyDetailEo.setCreditEntityCode(applyDetail.getCreditEntityCode());
            Assert.isTrue((boolean)DateTimeUtils.getDayStartTime((Date)applyDetail.getStartDate()).before(DateTimeUtils.getDayEndTime((Date)applyDetail.getEndDate())), (String)"\u6388\u6743\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
            Assert.isTrue((boolean)date.before(DateTimeUtils.getDayEndTime((Date)applyDetail.getEndDate())), (String)"\u6388\u6743\u6709\u6548\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u5929");
            creditApplyDetailEo.setCreditEntityName(applyDetail.getCreditEntityName());
            creditApplyDetailEo.setCreditEntityType(creditApplySaveReqDto.getCreditEntityType());
            creditApplyDetailEo.setEndDate(applyDetail.getEndDate());
            creditApplyDetailEo.setExtension(applyDetail.getExtension());
            creditApplyDetailEo.setQuota(applyDetail.getQuota());
            creditApplyDetailEo.setRemark(applyDetail.getRemark());
            creditApplyDetailEo.setStartDate(applyDetail.getStartDate());
            creditApplyDetailEo.setCreditDownStatus(CreditDownStatusEnum.WAIT.getCode());
            creditApplyDetailEo.setOrgInfoId(orgId);
            list.add(creditApplyDetailEo);
        }
        this.creditApplyDetailDas.insertBatch(list);
        RelateTypeEnum relateTypeEnum = RelateTypeEnum.CREDIT_APPLY;
        this.iAttachmentService.saveAttachment(creditApplyEo.getId(), relateTypeEnum, creditApplySaveReqDto.getAttachmentList());
        return creditApplyEo.getId();
    }

    @Override
    public PageInfo<CreditApplyPageRespDto> pageCreditApply(CreditApplySearchReqDto pageRequest) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        pageRequest.setOrgId(orgId);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (!StringUtils.isEmpty((Object)pageRequest.getCreditEntityName())) {
            CreditApplyDetailEo selectItemCreditApply = new CreditApplyDetailEo();
            sqlFilterList.add(SqlFilter.like((String)"credit_entity_name", (Object)("%" + pageRequest.getCreditEntityName() + "%")));
            sqlFilterList.add(SqlFilter.eq((String)"org_info_id", (Object)orgId));
            sqlFilterList.add(SqlFilter.ne((String)"credit_apply_status", (Object)3));
            selectItemCreditApply.setSqlFilters(sqlFilterList);
            List creditApplyDetailEos = this.creditApplyDetailDas.selectList((BaseEo)selectItemCreditApply);
            if (!CollectionUtils.isEmpty((Collection)creditApplyDetailEos)) {
                List applyIds = creditApplyDetailEos.stream().map(StdCreditApplyDetailEo::getCreditApplyId).collect(Collectors.toList());
                ArrayList list = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)pageRequest.getApplyIds())) {
                    list.addAll(pageRequest.getApplyIds());
                }
                list.addAll(applyIds);
                pageRequest.setApplyIds(list);
            } else {
                return new PageInfo();
            }
        }
        return this.creditApplyDas.pageCreditApply(pageRequest);
    }

    @Override
    public List<CreditApplyPageRespDto> findCreditApply(CreditApplySearchReqDto pageRequest) {
        return this.creditApplyDas.findCreditApply(pageRequest);
    }

    @Override
    public CreditApplyDetailRespDto findDetail(Long id) {
        CreditApplyDetailRespDto creditApplyDetailRespDto = new CreditApplyDetailRespDto();
        CreditApplyEo data = (CreditApplyEo)this.creditApplyDas.selectByPrimaryKey(id);
        Assert.notNull((Object)data, (String)(" \u4fe1\u7528\u7533\u8bf7\u4e0d\u80fd\u4e3a\u7a7a:id=" + id));
        creditApplyDetailRespDto.setApplyPerson(data.getApplyPerson());
        creditApplyDetailRespDto.setApplyTime(data.getApplyTime());
        creditApplyDetailRespDto.setApplyTimeString(DateTimeUtils.convertDateTimeToString((Date)data.getApplyTime()));
        creditApplyDetailRespDto.setApproveNo(data.getApproveNo());
        creditApplyDetailRespDto.setCreditApplyStatus(data.getCreditApplyStatus());
        creditApplyDetailRespDto.setCreditApplyStatusName(CreditApplyStatusEnum.toName((Integer)data.getCreditApplyStatus()));
        creditApplyDetailRespDto.setId(data.getId());
        creditApplyDetailRespDto.setQuotaType(data.getQuotaType());
        creditApplyDetailRespDto.setQuotaTypeName(QuotaTypeEnum.toName((Integer)data.getQuotaType()));
        creditApplyDetailRespDto.setReason(data.getReason());
        creditApplyDetailRespDto.setRemark(data.getRemark());
        creditApplyDetailRespDto.setApproveResult(data.getApproveResult());
        List attachmentEos = this.attachmentDas.findAttachment(id, RelateTypeEnum.CREDIT_APPLY);
        ArrayList list = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)attachmentEos, list, AttachmentReqDto.class);
        creditApplyDetailRespDto.setAttachmentReqDto(list);
        List<CreditApplyDetailEo> select = this.getCreditApplyDetailEos(id);
        Assert.isTrue((!CollectionUtils.isEmpty(select) ? 1 : 0) != 0, (String)("\u627e\u4e0d\u5230\u7533\u8bf7\u8be6\u60c5id:" + id));
        List collect = select.stream().map(this::buildCreditAccountModuleRespDto).collect(Collectors.toList());
        creditApplyDetailRespDto.setAccountList(collect);
        return creditApplyDetailRespDto;
    }

    @Override
    public void auditApply(CreditApplyAuditSaveReqDto creditApplyAuditSaveReqDto) {
        CreditApplyEo creditApplyFromD = (CreditApplyEo)this.creditApplyDas.selectByPrimaryKey(creditApplyAuditSaveReqDto.getId());
        Assert.notNull((Object)creditApplyFromD, (String)("\u627e\u4e0d\u5230id:" + creditApplyAuditSaveReqDto.getId()));
        Assert.isTrue((CreditApplyStatusEnum.fromCode((Integer)creditApplyFromD.getCreditApplyStatus()) == CreditApplyStatusEnum.WAIT ? 1 : 0) != 0, (String)("\u7533\u8bf7\u5355\u72b6\u6001\u5f02\u5e38id:" + creditApplyAuditSaveReqDto.getId()));
        CreditApplyEo creditApplyEo = new CreditApplyEo();
        creditApplyEo.setId(creditApplyAuditSaveReqDto.getId());
        creditApplyEo.setCreditApplyStatus(creditApplyAuditSaveReqDto.getCreditApplyStatus());
        creditApplyEo.setApproveResult(creditApplyAuditSaveReqDto.getApproveResult());
        this.creditApplyDas.updateSelective((BaseEo)creditApplyEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateReturn(CreditApplyUpdateReqDto creditApplyUpdateReqDto) {
        CreditApplyEo creditApplyFromD = (CreditApplyEo)this.creditApplyDas.selectByPrimaryKey(creditApplyUpdateReqDto.getId());
        Assert.notNull((Object)creditApplyFromD, (String)("\u627e\u4e0d\u5230id:" + creditApplyUpdateReqDto.getId()));
        Assert.isTrue((CreditApplyStatusEnum.fromCode((Integer)creditApplyFromD.getCreditApplyStatus()) == CreditApplyStatusEnum.WAIT || CreditApplyStatusEnum.fromCode((Integer)creditApplyFromD.getCreditApplyStatus()) == CreditApplyStatusEnum.FAIL ? 1 : 0) != 0, (String)("\u7533\u8bf7\u5355\u72b6\u6001\u5f02\u5e38id:" + creditApplyUpdateReqDto.getId()));
        CreditApplyEo creditApplyEo = new CreditApplyEo();
        creditApplyEo.setApplyPerson(StringUtils.isEmpty((Object)creditApplyUpdateReqDto.getApplyPerson()) ? this.iContext.userName() : creditApplyUpdateReqDto.getApplyPerson());
        creditApplyEo.setExtension(creditApplyUpdateReqDto.getExtension());
        creditApplyEo.setQuotaType(creditApplyUpdateReqDto.getQuotaType());
        creditApplyEo.setReason(creditApplyUpdateReqDto.getReason());
        creditApplyEo.setRemark(creditApplyUpdateReqDto.getRemark());
        creditApplyEo.setId(creditApplyUpdateReqDto.getId());
        creditApplyEo.setApproveResult(null);
        creditApplyEo.setCreditApplyStatus(CreditApplyStatusEnum.WAIT.getCode());
        this.creditApplyDas.updateSelective((BaseEo)creditApplyEo);
        this.creditApplyDetailDas.deleteOldDetail(creditApplyUpdateReqDto.getId());
        List applyDetails = creditApplyUpdateReqDto.getApplyDetails();
        ArrayList<CreditApplyDetailEo> newDetails = new ArrayList<CreditApplyDetailEo>();
        for (CreditApplyDetailsUpdateReqDto applyDetail : applyDetails) {
            CreditApplyDetailEo creditApplyDetailEo = new CreditApplyDetailEo();
            creditApplyDetailEo.setCreditEntityCode(applyDetail.getCreditEntityCode());
            creditApplyDetailEo.setCreditEntityName(applyDetail.getCreditEntityName());
            creditApplyDetailEo.setCreditEntityType(creditApplyUpdateReqDto.getCreditEntityType());
            creditApplyDetailEo.setCreditApplyId(creditApplyEo.getId());
            creditApplyDetailEo.setEndDate(applyDetail.getEndDate());
            creditApplyDetailEo.setExtension(applyDetail.getExtension());
            creditApplyDetailEo.setQuota(applyDetail.getQuota());
            creditApplyDetailEo.setRemark(applyDetail.getRemark());
            creditApplyDetailEo.setStartDate(applyDetail.getStartDate());
            creditApplyDetailEo.setCreditDownStatus(CreditDownStatusEnum.WAIT.getCode());
            newDetails.add(creditApplyDetailEo);
        }
        this.creditApplyDetailDas.insertBatch(newDetails);
        RelateTypeEnum relateTypeEnum = RelateTypeEnum.CREDIT_APPLY;
        this.iAttachmentService.updateAttachment(creditApplyEo.getId(), relateTypeEnum, creditApplyUpdateReqDto.getAttachmentList());
    }

    @Override
    @Transactional
    public void delete(Long creditApplyId) {
        CreditApplyEo creditApplyEo = new CreditApplyEo();
        creditApplyEo.setId(creditApplyId);
        creditApplyEo.setDr(0);
        List select = this.creditApplyDas.select((BaseEo)creditApplyEo);
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)select) ? 1 : 0) != 0, (String)("\u627e\u4e0d\u5230\u7533\u8bf7\u5355Id:" + creditApplyId));
        this.creditApplyDas.logicDeleteById(creditApplyId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCreditDown(CreditDownSaveReqDto creditDownSaveReqDto) {
        CreditApplyEo creditApply = this.creditApplyDas.findByApplyId(creditDownSaveReqDto.getApplyId());
        Assert.notNull((Object)creditApply, (String)("\u627e\u4e0d\u5230id:" + creditDownSaveReqDto.getApplyId()));
        Assert.isTrue((CreditApplyStatusEnum.fromCode((Integer)creditApply.getCreditApplyStatus()) == CreditApplyStatusEnum.SUCCESS || CreditApplyStatusEnum.fromCode((Integer)creditApply.getCreditApplyStatus()) == CreditApplyStatusEnum.RECEIVED ? 1 : 0) != 0, (String)("\u7533\u8bf7\u5355\u72b6\u6001\u5f02\u5e38,\u5f53\u524d\u72b6\u6001:" + CreditApplyStatusEnum.toName((Integer)creditApply.getCreditApplyStatus())));
        this.checkAmount(creditDownSaveReqDto);
        List updateList = creditDownSaveReqDto.getApplyAccounts().stream().filter(account -> account.getAccountId() != null).collect(Collectors.toList());
        for (CreditApplyQuotaItemSaveReqDto creditApplyQuotaItemSaveReqDto : updateList) {
            CreditAccountEo creditAccountEo = (CreditAccountEo)this.creditAccountDas.selectByPrimaryKey(creditApplyQuotaItemSaveReqDto.getAccountId());
            Assert.isTrue((creditAccountEo != null ? 1 : 0) != 0, (String)("\u627e\u4e0d\u5230\u8d26\u53f7,\u8d26\u53f7id:" + creditApplyQuotaItemSaveReqDto.getAccountId()));
            if (creditApplyQuotaItemSaveReqDto.getCreditAccountStatus() != null) {
                if (CreditAccountStatusEnum.fromCode((Integer)creditApplyQuotaItemSaveReqDto.getCreditAccountStatus()) == CreditAccountStatusEnum.NOT_EFFECT) {
                    creditAccountEo.setAccountUsedQuota(BigDecimal.ZERO);
                }
                creditAccountEo.setCreditAccountStatus(creditApplyQuotaItemSaveReqDto.getCreditAccountStatus());
            }
            this.creditAccountDas.updateSelective((BaseEo)creditAccountEo);
        }
        List addList = creditDownSaveReqDto.getApplyAccounts().stream().filter(account -> account.getAccountId() == null).collect(Collectors.toList());
        CreditApplyQuotaSaveReqDto creditApplyQuotaSaveReqDto = new CreditApplyQuotaSaveReqDto();
        creditApplyQuotaSaveReqDto.setApplyId(creditDownSaveReqDto.getApplyId());
        creditApplyQuotaSaveReqDto.setApplyAccounts(addList);
        creditApplyQuotaSaveReqDto.setApplyType(creditApplyQuotaSaveReqDto.getApplyType() == null ? CreditApplyTypeEnum.SXSQ.getCode() : creditApplyQuotaSaveReqDto.getApplyType());
        creditApplyQuotaSaveReqDto.setQuotaType(creditApply.getQuotaType());
        this.iCreditAccountService.addAccount(creditApplyQuotaSaveReqDto);
        for (CreditRecordBatchSaveReqDto creditRecord : creditDownSaveReqDto.getCreditRecords()) {
            creditRecord.setApplyType(CreditApplyTypeEnum.SXSQ.getCode());
            creditRecord.setQuotaType(creditApply.getQuotaType());
            creditRecord.setApplyId(creditApply.getId());
            creditRecord.setCreditRecordCode(creditApply.getApproveNo());
            creditRecord.setOrgInfoId(creditApply.getOrgInfoId());
            creditRecord.setRemark(creditRecord.getQuotaType() == 1 ? CreditUsageRecordType.TEMP_QUOTA.getDesc() : CreditUsageRecordType.RULE_QUOTA.getDesc());
        }
        this.logger.info("------------------------------------------------\u989d\u5ea6\u4e0b\u53d1,\u8fdb\u884c\u5907\u6ce8\u4fee\u6b63{}", (Object)JSON.toJSONString((Object)creditDownSaveReqDto.getCreditRecords()));
        this.iCreditRecordService.batchAddOrUpdateQuota(creditDownSaveReqDto.getCreditRecords());
        creditDownSaveReqDto.setApplyAccounts(addList);
        this.updateApplyState(creditDownSaveReqDto, creditApply);
        return creditDownSaveReqDto.getApplyId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateApplyState(CreditDownSaveReqDto creditDownSaveReqDto, CreditApplyEo creditApply) {
        HashSet<String> UpdateEntity = new HashSet<String>();
        List code1 = creditDownSaveReqDto.getApplyAccounts().stream().map(CreditApplyQuotaItemSaveReqDto::getCreditEntityCode).collect(Collectors.toList());
        List code2 = creditDownSaveReqDto.getCreditRecords().stream().map(CreditRecordBatchSaveReqDto::getCreditEntityCode).collect(Collectors.toList());
        UpdateEntity.addAll(code1);
        UpdateEntity.addAll(code2);
        List allEntity = this.creditApplyDetailDas.findByApplyId(creditDownSaveReqDto.getApplyId());
        List<CreditApplyDetailEo> successList = allEntity.stream().filter(detailEo -> CreditDownStatusEnum.SUCCESS.getCode().equals(detailEo.getCreditDownStatus())).collect(Collectors.toList());
        this.checkData(UpdateEntity, allEntity, successList);
        for (CreditApplyDetailEo creditApplyDetail : allEntity) {
            if (!UpdateEntity.contains(creditApplyDetail.getCreditEntityCode())) continue;
            creditApplyDetail.setCreditDownStatus(CreditDownStatusEnum.SUCCESS.getCode());
            this.creditApplyDetailDas.updateSelective((BaseEo)creditApplyDetail);
        }
        if (successList.size() + UpdateEntity.size() == allEntity.size()) {
            creditApply.setCreditApplyStatus(CreditApplyStatusEnum.DOWNED.getCode());
        }
        if (successList.size() + UpdateEntity.size() < allEntity.size()) {
            creditApply.setCreditApplyStatus(CreditApplyStatusEnum.RECEIVED.getCode());
        }
        this.creditApplyDas.update((BaseEo)creditApply);
    }

    private void checkData(Set<String> entityCodes, List<CreditApplyDetailEo> creditApplyDetails, List<CreditApplyDetailEo> successList) {
        for (CreditApplyDetailEo creditApplyDetailEo : successList) {
            if (!entityCodes.contains(creditApplyDetailEo.getCreditEntityCode())) continue;
            throw new BizException("\u91cd\u590d\u4e0b\u53d1\u68c0\u67e5,\u91cd\u590d\u4e3b\u4f53\u7f16\u7801\u4e3a" + creditApplyDetailEo.getCreditEntityCode());
        }
        Assert.isTrue((successList.size() + entityCodes.size() <= creditApplyDetails.size() ? 1 : 0) != 0, (String)"\u6570\u76ee\u91cd\u590d,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u4e3b\u4f53\u91cd\u590d\u4e0b\u53d1");
    }

    private void checkAmount(CreditDownSaveReqDto creditDownSaveReqDto) {
        List applyAccounts = CollectionUtils.isEmpty((Collection)creditDownSaveReqDto.getApplyAccounts()) ? new ArrayList() : creditDownSaveReqDto.getApplyAccounts();
        Map accountGroup = applyAccounts.stream().filter(account -> account.getAccountId() == null).collect(Collectors.groupingBy(CreditApplyQuotaItemSaveReqDto::getCreditEntityCode, Collectors.toList()));
        List creditRecords = CollectionUtils.isEmpty((Collection)creditDownSaveReqDto.getCreditRecords()) ? new ArrayList() : creditDownSaveReqDto.getCreditRecords();
        Map recordGroup = creditRecords.stream().collect(Collectors.groupingBy(CreditRecordBatchSaveReqDto::getCreditEntityCode, Collectors.toList()));
        List creditApplyDetails = this.creditApplyDetailDas.findByApplyId(creditDownSaveReqDto.getApplyId());
        for (CreditApplyDetailEo creditApplyDetail : creditApplyDetails) {
            if (CollectionUtils.isEmpty((Collection)accountGroup.get(creditApplyDetail.getCreditEntityCode())) && CollectionUtils.isEmpty((Collection)recordGroup.get(creditApplyDetail.getCreditEntityCode()))) continue;
            ArrayList accountGroupItem = CollectionUtils.isEmpty((Collection)accountGroup.get(creditApplyDetail.getCreditEntityCode())) ? new ArrayList() : accountGroup.get(creditApplyDetail.getCreditEntityCode());
            BigDecimal accountTotalAmount = accountGroupItem.stream().map(item -> item.getAccountQuota() == null ? BigDecimal.ZERO : item.getAccountQuota()).reduce(BigDecimal.ZERO, BigDecimal::add);
            ArrayList recordGroupItem = CollectionUtils.isEmpty((Collection)recordGroup.get(creditApplyDetail.getCreditEntityCode())) ? new ArrayList() : recordGroup.get(creditApplyDetail.getCreditEntityCode());
            BigDecimal recordTotalAmount = recordGroupItem.stream().map(item -> item.getAccountQuota() == null ? BigDecimal.ZERO : item.getAccountQuota()).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.isTrue((creditApplyDetail.getQuota().compareTo(accountTotalAmount.add(recordTotalAmount)) >= 0 ? 1 : 0) != 0, (String)("\u4e3b\u4f53\u4e0b\u53d1\u989d\u5ea6\u4e0e\u5ef6\u957f\u6709\u6548\u671f\u7684\u989d\u5ea6\u4e4b\u548c(" + accountTotalAmount.add(recordTotalAmount) + ")\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u989d\u5ea6(" + creditApplyDetail.getQuota() + ")"));
            Date date = new Date();
            for (CreditRecordBatchSaveReqDto creditRecordSaveReqDto : creditDownSaveReqDto.getCreditRecords()) {
                Assert.isTrue((!DateTimeUtils.getDayEndTime((Date)creditRecordSaveReqDto.getEndDate()).before(date) ? 1 : 0) != 0, (String)"\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
                Assert.isTrue((boolean)DateTimeUtils.getDayEndTime((Date)creditRecordSaveReqDto.getEndDate()).after(creditRecordSaveReqDto.getStartDate()), (String)"\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4");
            }
        }
    }

    @Override
    public void deleteRecord(Long applyId, List<Long> creditEntityIds) {
        for (Long creditEntityId : creditEntityIds) {
            CreditRecordEo selectItemCreditRecord = new CreditRecordEo();
            selectItemCreditRecord.setCreditApplyId(applyId);
            selectItemCreditRecord.setCreditEntityId(creditEntityId);
            List creditEntityEos = this.creditRecordDas.selectList((BaseEo)selectItemCreditRecord);
            for (CreditRecordEo entityEo : creditEntityEos) {
                this.creditRecordDas.logicDelete((BaseEo)entityEo);
                this.creditAccountDas.logicDeleteById(entityEo.getCreditAccountId());
            }
        }
    }

    @Override
    @Transactional
    public void batchAddCreditDown(CreditDownBatchSaveReqDto creditDownSaveReqDto) {
        CreditApplyQuotaSaveReqDto creditApplyQuotaSaveReqDto = new CreditApplyQuotaSaveReqDto();
        ArrayList<CreditApplyQuotaItemSaveReqDto> creditApplyQuotaItemSaveReqDtos = new ArrayList<CreditApplyQuotaItemSaveReqDto>();
        ArrayList<CreditRecordBatchSaveReqDto> creditRecords = new ArrayList<CreditRecordBatchSaveReqDto>();
        List entityIds = creditDownSaveReqDto.getCustomerItems().stream().map(CreditBatchQuotaItemSaveReqDto::getCreditEntityId).collect(Collectors.toList());
        List creditAccountEos = this.creditAccountDas.queryAccountByEntityIdsAndDimId(entityIds, creditDownSaveReqDto.getDim1Id(), creditDownSaveReqDto.getDim2Id());
        Map<Long, List<CreditAccountEo>> group = creditAccountEos.stream().collect(Collectors.groupingBy(StdCreditAccountEo::getCreditEntityId, Collectors.toList()));
        for (CreditBatchQuotaItemSaveReqDto customerItem : creditDownSaveReqDto.getCustomerItems()) {
            if (customerItem.getCreditAccountCode() == null) {
                creditApplyQuotaItemSaveReqDtos.add(this.buildAddAccount(creditDownSaveReqDto, customerItem));
                continue;
            }
            creditRecords.add(this.getCreditRecordBatchSaveReqDto(creditDownSaveReqDto, group, customerItem));
        }
        creditApplyQuotaSaveReqDto.setApplyAccounts(creditApplyQuotaItemSaveReqDtos);
        creditApplyQuotaSaveReqDto.setApplyType(creditApplyQuotaSaveReqDto.getApplyType() == null ? CreditApplyTypeEnum.PLSX.getCode() : creditApplyQuotaSaveReqDto.getApplyType());
        this.iCreditAccountService.addAccount(creditApplyQuotaSaveReqDto);
        for (CreditRecordBatchSaveReqDto creditRecord : creditRecords) {
            creditRecord.setApplyType(CreditApplyTypeEnum.PLSX.getCode());
            creditRecord.setRemark(creditRecord.getQuotaType() != null && creditRecord.getQuotaType() == 1 ? CreditUsageRecordType.TEMP_QUOTA.getDesc() : CreditUsageRecordType.RULE_QUOTA.getDesc());
        }
        this.iCreditRecordService.batchAddOrUpdateQuota(creditRecords);
        this.dealEntityCreditTime(creditDownSaveReqDto);
    }

    @Override
    public List<CreditApplyDownEntityRespDto> findDownDetail(Long applyId) {
        ArrayList<CreditApplyDownEntityRespDto> list = new ArrayList<CreditApplyDownEntityRespDto>();
        this.logger.info("\u5f00\u59cb\u6574\u7406\u6570\u636e\u5b8c\u6bd5,\u5f00\u59cb\u7ec4\u88c5\u6570\u636e,\u7533\u8bf7id" + applyId);
        List<CreditApplyDetailEo> applyDetails = this.getCreditApplyDetailEos(applyId);
        List creditRecordEos = this.creditRecordDas.findByApplyId(applyId);
        if (CollectionUtils.isEmpty((Collection)creditRecordEos)) {
            return list;
        }
        Map groupCreditRecordEo = creditRecordEos.stream().collect(Collectors.groupingBy(StdCreditRecordEo::getCreditEntityId, Collectors.toList()));
        List accountIds = creditRecordEos.stream().map(StdCreditRecordEo::getCreditAccountId).collect(Collectors.toList());
        List creditAccountEos = this.creditAccountDas.queryByIds(accountIds);
        List creditTermModelIds = creditAccountEos.stream().map(StdCreditAccountEo::getCreditTermModelId).collect(Collectors.toList());
        List overdueStrategyId = creditAccountEos.stream().map(StdCreditAccountEo::getOverdueStrategyId).collect(Collectors.toList());
        List quotaStrategyId = creditAccountEos.stream().map(StdCreditAccountEo::getQuotaStrategyId).collect(Collectors.toList());
        HashSet policyIds = new HashSet();
        policyIds.addAll(overdueStrategyId);
        policyIds.addAll(quotaStrategyId);
        Map policyNameMap = this.policyDas.queryNameByIds(new ArrayList(policyIds));
        Map idAndCreditAccountGroup = creditAccountEos.stream().collect(Collectors.groupingBy(BaseEo::getId, Collectors.toList()));
        Map<String, List<CreditEntityEo>> entityCodeAndEntityGroup = this.getEntityStringListMap(applyDetails);
        Map creditTermModelEosGroup = this.creditTermModelDas.getCreditTermMode(creditTermModelIds);
        this.logger.info("\u6574\u7406\u6570\u636e\u5b8c\u6bd5,\u5f00\u59cb\u7ec4\u88c5\u6570\u636e,\u5176\u4e2d\u7b56\u7565:" + policyIds.size() + "\u4e2a \u6a21\u578b:" + creditTermModelIds.size() + "\u4e2a\u6d89\u53ca\u4e3b\u4f53" + applyDetails.size() + "\u4e2a");
        for (CreditApplyDetailEo applyDetailEo : applyDetails) {
            CreditApplyDownEntityRespDto creditApplyDownEntityRespDto = new CreditApplyDownEntityRespDto();
            List<CreditEntityEo> creditEntityEos = entityCodeAndEntityGroup.get(applyDetailEo.getCreditEntityCode());
            Assert.isTrue((!CollectionUtils.isEmpty(creditEntityEos) ? 1 : 0) != 0, (String)"\u627e\u4e0d\u5230\u4fe1\u7528\u4e3b\u4f53");
            CreditEntityEo creditEntityEo = creditEntityEos.get(0);
            creditApplyDownEntityRespDto.setCreditEntityCode(creditEntityEo.getCode());
            creditApplyDownEntityRespDto.setCreditEntityId(creditEntityEo.getId());
            creditApplyDownEntityRespDto.setCreditEntityName(creditEntityEo.getName());
            ArrayList groupCreditRecordEos = groupCreditRecordEo.get(creditEntityEo.getId());
            ArrayList<CreditApplyDownAccountRespDto> creditApplyDownAccountRespDtos = new ArrayList<CreditApplyDownAccountRespDto>();
            groupCreditRecordEos = groupCreditRecordEos == null ? new ArrayList() : groupCreditRecordEos;
            for (CreditRecordEo creditRecordEo : groupCreditRecordEos) {
                List creditAccountEos1 = idAndCreditAccountGroup.get(creditRecordEo.getCreditAccountId());
                Assert.isTrue((!CollectionUtils.isEmpty(creditAccountEos1) ? 1 : 0) != 0, (String)"\u627e\u4e0d\u5230\u4fe1\u7528\u8d26\u53f7");
                CreditAccountEo creditAccountEo = (CreditAccountEo)creditAccountEos1.get(0);
                CreditApplyDownAccountRespDto creditApplyDownRespDto = new CreditApplyDownAccountRespDto();
                creditApplyDownRespDto.setCreditAccountCode(creditAccountEo.getCreditAccountCode());
                creditApplyDownRespDto.setCreditTermModelId(creditAccountEo.getCreditTermModelId());
                CreditTermModelEo creditTermModelEo = CollectionUtils.isEmpty((Collection)((Collection)creditTermModelEosGroup.get(creditAccountEo.getCreditTermModelId()))) ? new CreditTermModelEo() : (CreditTermModelEo)((List)creditTermModelEosGroup.get(creditAccountEo.getCreditTermModelId())).get(0);
                creditApplyDownRespDto.setCreditTermModelName(creditTermModelEo.getName());
                creditApplyDownRespDto.setDim1Value(null == creditAccountEo.getDim1Value() ? "\u4e0d\u9650" : creditAccountEo.getDim1Value());
                creditApplyDownRespDto.setDim2Value(null == creditAccountEo.getDim2Value() ? "\u4e0d\u9650" : creditAccountEo.getDim2Value());
                creditApplyDownRespDto.setId(creditRecordEo.getId());
                CreditRecordEo firstRecord = this.creditRecordDas.findFirstRecord(creditEntityEo.getId());
                creditApplyDownRespDto.setDownType(Integer.valueOf(firstRecord != null && firstRecord.getId().equals(creditRecordEo.getId()) ? 1 : 2));
                creditApplyDownRespDto.setEndDate(DateTimeUtils.getDayEndTime((Date)creditRecordEo.getEndDate()));
                creditApplyDownRespDto.setGrantQuota(creditRecordEo.getGrantQuota());
                creditApplyDownRespDto.setOverdueStrategyId(creditAccountEo.getOverdueStrategyId());
                creditApplyDownRespDto.setQuotaStrategyId(creditAccountEo.getQuotaStrategyId());
                creditApplyDownRespDto.setQuotaStrategyName((String)policyNameMap.get(creditAccountEo.getQuotaStrategyId()));
                creditApplyDownRespDto.setOverdueStrategyName((String)policyNameMap.get(creditAccountEo.getOverdueStrategyId()));
                creditApplyDownRespDto.setQuotaType(creditRecordEo.getQuotaType());
                creditApplyDownRespDto.setStartDate(creditRecordEo.getStartDate());
                creditApplyDownAccountRespDtos.add(creditApplyDownRespDto);
            }
            creditApplyDownEntityRespDto.setCreditApplyDownAccounts(creditApplyDownAccountRespDtos);
            BigDecimal amounts1 = creditApplyDownAccountRespDtos.stream().map(item -> item.getGrantQuota() == null ? BigDecimal.ZERO : item.getGrantQuota()).reduce(BigDecimal.ZERO, BigDecimal::add);
            creditApplyDownEntityRespDto.setTotalQuota(amounts1);
            list.add(creditApplyDownEntityRespDto);
        }
        return list;
    }

    private List<CreditApplyDetailEo> getCreditApplyDetailEos(Long applyId) {
        CreditApplyDetailEo creditApplyDetailEo = new CreditApplyDetailEo();
        creditApplyDetailEo.setCreditApplyId(applyId);
        return this.creditApplyDetailDas.select((BaseEo)creditApplyDetailEo);
    }

    private Map<String, List<CreditEntityEo>> getEntityStringListMap(List<CreditApplyDetailEo> select) {
        List entityCodes = select.stream().map(StdCreditApplyDetailEo::getCreditEntityCode).collect(Collectors.toList());
        List byEntityCodes = this.creditEntityDas.findByEntityCodes(entityCodes);
        Map<String, List<CreditEntityEo>> entity = byEntityCodes.stream().collect(Collectors.groupingBy(StdCreditEntityEo::getCode, Collectors.toList()));
        return entity;
    }

    private void dealEntityCreditTime(CreditDownBatchSaveReqDto creditDownSaveReqDto) {
        List entityCodes = creditDownSaveReqDto.getCustomerItems().stream().map(CreditBatchQuotaItemSaveReqDto::getCreditEntityCode).collect(Collectors.toList());
        CreditApplyDetailEo selectItemCreditApplyDetail = new CreditApplyDetailEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"credit_entity_code", entityCodes));
        selectItemCreditApplyDetail.setSqlFilters(sqlFilterList);
        List creditApplyDetailEos = this.creditApplyDetailDas.selectList((BaseEo)selectItemCreditApplyDetail);
        Map collectGroup = creditApplyDetailEos.stream().filter(data -> data.getCreditDownStatus() == 2).collect(Collectors.groupingBy(StdCreditApplyDetailEo::getCreditEntityCode, Collectors.toList()));
        Date date = new Date();
        for (String entityCode : entityCodes) {
            if (!CollectionUtils.isEmpty((Collection)collectGroup.get(entityCode))) continue;
            this.creditEntityDas.updateCreditEntityCreateTime(date, entityCode);
        }
    }

    private CreditRecordBatchSaveReqDto getCreditRecordBatchSaveReqDto(CreditDownBatchSaveReqDto creditDownSaveReqDto, Map<Long, List<CreditAccountEo>> group, CreditBatchQuotaItemSaveReqDto customerItem) {
        CreditRecordBatchSaveReqDto creditRecordBatchSaveReqDto = new CreditRecordBatchSaveReqDto();
        creditRecordBatchSaveReqDto.setAccountQuota(customerItem.getAccountQuota());
        creditRecordBatchSaveReqDto.setCreditEntityCode(customerItem.getCreditEntityCode());
        creditRecordBatchSaveReqDto.setCreditEntityId(customerItem.getCreditEntityId());
        creditRecordBatchSaveReqDto.setCreditRecordStatus(CreditRecordStatusEnum.GOOD.getCode());
        creditRecordBatchSaveReqDto.setCreditAccountStatus(customerItem.getCreditAccountStatus());
        List<CreditAccountEo> accountGroupItem = group.get(customerItem.getCreditEntityId());
        if (CollectionUtils.isEmpty(accountGroupItem)) {
            throw new BizException("\u4fe1\u7528\u8d26\u6237\u4e0d\u5b58\u5728,entityId:" + customerItem.getCreditEntityId());
        }
        creditRecordBatchSaveReqDto.setCreditAccountId(accountGroupItem.get(0).getId());
        creditRecordBatchSaveReqDto.setEndDate(customerItem.getEndDay());
        creditRecordBatchSaveReqDto.setQuotaType(creditDownSaveReqDto.getQuotaType());
        creditRecordBatchSaveReqDto.setRemark(creditDownSaveReqDto.getQuotaType() == 1 ? CreditUsageRecordType.TEMP_QUOTA.getDesc() : CreditUsageRecordType.RULE_QUOTA.getDesc());
        creditRecordBatchSaveReqDto.setStartDate(customerItem.getStartDay());
        return creditRecordBatchSaveReqDto;
    }

    private CreditApplyQuotaItemSaveReqDto buildAddAccount(CreditDownBatchSaveReqDto creditDownSaveReqDto, CreditBatchQuotaItemSaveReqDto customerItem) {
        CreditApplyQuotaItemSaveReqDto creditApplyQuotaItemSaveReqDto = new CreditApplyQuotaItemSaveReqDto();
        creditApplyQuotaItemSaveReqDto.setAccountQuota(customerItem.getAccountQuota());
        creditApplyQuotaItemSaveReqDto.setApplyQuota(customerItem.getApplyQuota());
        creditApplyQuotaItemSaveReqDto.setCreditAccountName(customerItem.getCreditAccountName());
        creditApplyQuotaItemSaveReqDto.setCreditEntityCode(customerItem.getCreditEntityCode());
        creditApplyQuotaItemSaveReqDto.setCreditEntityId(customerItem.getCreditEntityId());
        creditApplyQuotaItemSaveReqDto.setEndDay(customerItem.getEndDay());
        creditApplyQuotaItemSaveReqDto.setExtension(customerItem.getExtension());
        creditApplyQuotaItemSaveReqDto.setStartDay(customerItem.getStartDay());
        creditApplyQuotaItemSaveReqDto.setCreditAccountStatus(customerItem.getCreditAccountStatus());
        creditApplyQuotaItemSaveReqDto.setCreditTermModelId(creditDownSaveReqDto.getCreditTermModelId());
        creditApplyQuotaItemSaveReqDto.setDim1Id(creditDownSaveReqDto.getDim1Id());
        creditApplyQuotaItemSaveReqDto.setDim1Value(creditDownSaveReqDto.getDim1Value());
        creditApplyQuotaItemSaveReqDto.setDim2Id(creditDownSaveReqDto.getDim2Id());
        creditApplyQuotaItemSaveReqDto.setDim2Value(creditDownSaveReqDto.getDim2Value());
        creditApplyQuotaItemSaveReqDto.setOverdueStrategyId(creditDownSaveReqDto.getOverdueStrategyId());
        creditApplyQuotaItemSaveReqDto.setQuotaStrategyId(creditDownSaveReqDto.getQuotaStrategyId());
        creditApplyQuotaItemSaveReqDto.setQuotaType(creditDownSaveReqDto.getQuotaType());
        return creditApplyQuotaItemSaveReqDto;
    }

    private CreditAccountModuleRespDto buildCreditAccountModuleRespDto(CreditApplyDetailEo creditApplyDetailEo) {
        CreditAccountModuleRespDto creditAccountModuleRespDto = new CreditAccountModuleRespDto();
        creditAccountModuleRespDto.setQuota(creditApplyDetailEo.getQuota());
        creditAccountModuleRespDto.setCreditEntityCode(creditApplyDetailEo.getCreditEntityCode());
        creditAccountModuleRespDto.setCreditEntityName(creditApplyDetailEo.getCreditEntityName());
        creditAccountModuleRespDto.setEndDate(creditApplyDetailEo.getEndDate());
        creditAccountModuleRespDto.setEndDateString(DateTimeUtils.convertDateToString((Date)creditApplyDetailEo.getEndDate()));
        creditAccountModuleRespDto.setStartDate(creditApplyDetailEo.getStartDate());
        creditAccountModuleRespDto.setStartDateString(DateTimeUtils.convertDateToString((Date)creditApplyDetailEo.getStartDate()));
        creditAccountModuleRespDto.setCreditEntityType(creditApplyDetailEo.getCreditEntityType());
        creditAccountModuleRespDto.setCreatePerson(creditApplyDetailEo.getCreatePerson());
        creditAccountModuleRespDto.setCreditDownStatus(creditApplyDetailEo.getCreditDownStatus());
        CreditEntityEo selectItemCreditEntity = new CreditEntityEo();
        Long entityId = this.changeCodeToId(creditApplyDetailEo, selectItemCreditEntity);
        creditAccountModuleRespDto.setCreditEntityId(entityId);
        CreditEntityDetailEo selectItemCreditEntityDetail = new CreditEntityDetailEo();
        selectItemCreditEntityDetail.setCreditEntityId(entityId);
        List creditEntityDetailEos = this.creditEntityDetailDas.selectList((BaseEo)selectItemCreditEntityDetail);
        int count = this.getCount(entityId);
        creditAccountModuleRespDto.setAccountNum(Integer.valueOf(count));
        DtoHelper.eo2Dto((BaseEo)creditApplyDetailEo, (BaseVo)creditAccountModuleRespDto);
        creditAccountModuleRespDto.setCustomerCode(CollectionUtils.isEmpty((Collection)creditEntityDetailEos) ? null : ((CreditEntityDetailEo)creditEntityDetailEos.get(0)).getCustomerCode());
        return creditAccountModuleRespDto;
    }

    private int getCount(Long entityId) {
        CreditAccountEo selectItemCreditAccount = new CreditAccountEo();
        CreditEntityDetailEo selectItemCreditEntityDetail = new CreditEntityDetailEo();
        selectItemCreditEntityDetail.setCustomerId(entityId);
        List creditEntityDetailEos = this.creditEntityDetailDas.selectList((BaseEo)selectItemCreditEntityDetail);
        List<Long> entityIdCollect = creditEntityDetailEos.stream().map(StdCreditEntityDetailEo::getCreditEntityId).collect(Collectors.toList());
        entityIdCollect = CollectionUtils.isEmpty(entityIdCollect) ? new ArrayList<Long>() : entityIdCollect;
        entityIdCollect.add(entityId);
        entityIdCollect = entityIdCollect.stream().distinct().collect(Collectors.toList());
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"credit_entity_id", entityIdCollect));
        selectItemCreditAccount.setSqlFilters(sqlFilterList);
        selectItemCreditAccount.setDr(0);
        return this.creditAccountDas.count((BaseEo)selectItemCreditAccount);
    }

    private Long changeCodeToId(CreditApplyDetailEo creditApplyDetailEo, CreditEntityEo selectItemCreditEntity) {
        selectItemCreditEntity.setCode(creditApplyDetailEo.getCreditEntityCode());
        List select = this.creditEntityDas.select((BaseEo)selectItemCreditEntity);
        CreditEntityEo creditEntityEo = CollectionUtils.isEmpty((Collection)select) ? null : (CreditEntityEo)select.get(0);
        Assert.notNull((Object)creditEntityEo, (String)("\u627e\u4e0d\u5230\u4e3b\u4f53\u7f16\u7801:" + creditApplyDetailEo.getCreditEntityCode()));
        return creditEntityEo.getId();
    }
}

