/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountUpdateQuotaReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditUsageSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditUsageRecordRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditUsageRecordTotalRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountUpdateTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageRecordType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.RestResponseCreditHelper;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditUsageRecordService;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDetailDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditUsageRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditUsageRecordEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditUsageRecordEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="creditUsageRecord")
public class CreditUsageRecordServiceImpl
implements ICreditUsageRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IContext iContext;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private CreditUsageRecordDas creditUsageRecordDas;
    @Autowired
    private ICreditAccountService iCreditAccountService;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Resource
    private CreditEntityDetailDas creditEntityDetailDas;
    @Resource
    private CreditEntityDas creditEntityDas;

    public PageInfo<CreditUsageRecordRespDto> queryPage(CreditUsageSearchReqDto searchReqDto) {
        PageInfo pageInfo = new PageInfo();
        ArrayList sqlFilterList = Lists.newArrayList();
        List<CreditAccountEo> accountEoList = Lists.newArrayList();
        ArrayList entityIds = new ArrayList();
        Long belongOrgId = searchReqDto.getOrgId();
        if (belongOrgId == null && "Y".equalsIgnoreCase(searchReqDto.getIsMang())) {
            belongOrgId = (Long)this.iCustomerExtQueryApi.queryOrgIdByUserId(this.iContext.userId()).getData();
        }
        if (null != searchReqDto.getCreditEntityId() || StringUtils.isNotEmpty((CharSequence)searchReqDto.getCreditAccountCode())) {
            CreditAccountEo creditAccountEo = new CreditAccountEo();
            creditAccountEo.setCreditAccountCode(searchReqDto.getCreditAccountCode());
            creditAccountEo.setCreditEntityId(searchReqDto.getCreditEntityId());
            creditAccountEo.setOrgInfoId(belongOrgId);
            accountEoList = this.creditAccountDas.select((BaseEo)creditAccountEo);
            if (CollectionUtils.isEmpty((Collection)accountEoList)) {
                return pageInfo;
            }
            sqlFilterList.clear();
            List accountIds = accountEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            sqlFilterList.add(SqlFilter.in((String)"credit_account_id", accountIds));
        }
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getUsageRecordNo())) {
            sqlFilterList.add(SqlFilter.like((String)"usage_record_no", (Object)("%" + searchReqDto.getUsageRecordNo() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getCreateTimeStart()) && StringUtils.isNotEmpty((CharSequence)searchReqDto.getCreateTimeEnd())) {
            sqlFilterList.add(SqlFilter.ge((String)"create_time", (Object)searchReqDto.getCreateTimeStart()));
            sqlFilterList.add(SqlFilter.le((String)"create_time", (Object)searchReqDto.getCreateTimeEnd()));
        }
        CreditUsageRecordEo creditUsageRecordEo = new CreditUsageRecordEo();
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getType())) {
            sqlFilterList.add(SqlFilter.like((String)"remark", (Object)(searchReqDto.getType() + "%")));
        }
        creditUsageRecordEo.setOrderByDesc("create_time");
        creditUsageRecordEo.setSqlFilters((List)sqlFilterList);
        if (belongOrgId != null) {
            creditUsageRecordEo.setOrgInfoId(belongOrgId);
        } else {
            List customerIds = (List)this.iCustomerExtQueryApi.queryCustomerIdsByUserId(this.iContext.userId()).getData();
            sqlFilterList.add(SqlFilter.in((String)"customer_id", (Object)customerIds));
        }
        PageHelper.startPage((int)searchReqDto.getPageNum(), (int)searchReqDto.getPageSize());
        PageInfo select = new PageInfo(this.creditUsageRecordDas.select((BaseEo)creditUsageRecordEo));
        this.joinList((PageInfo<CreditUsageRecordRespDto>)pageInfo, accountEoList, (PageInfo<CreditUsageRecordEo>)select);
        return pageInfo;
    }

    private void joinList(PageInfo<CreditUsageRecordRespDto> pageInfo, List<CreditAccountEo> accountEoList, PageInfo<CreditUsageRecordEo> select) {
        if (CollectionUtils.isNotEmpty((Collection)select.getList())) {
            ArrayList list = Lists.newArrayList();
            BeanUtils.copyProperties(select, pageInfo, (String[])new String[]{"list"});
            CubeBeanUtils.copyCollection((Collection)list, (Collection)select.getList(), CreditUsageRecordRespDto.class);
            List accountIds = select.getList().stream().map(StdCreditUsageRecordEo::getCreditAccountId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(accountEoList)) {
                accountEoList = this.creditAccountDas.queryByIds(accountIds);
            }
            Map<Long, CreditAccountEo> map = accountEoList.stream().collect(Collectors.toMap(BaseEo::getId, entity -> entity));
            Map entityTypeMap = this.creditEntityDas.queryEntityTypeByIds(this.creditAccountDas.queryEntityIdById(accountIds));
            for (CreditUsageRecordRespDto creditUsageRecordRespDto : list) {
                CustomerRespDto customerRespDto;
                if (map.containsKey(creditUsageRecordRespDto.getCreditAccountId())) {
                    CreditAccountEo creditAccountEo = map.get(creditUsageRecordRespDto.getCreditAccountId());
                    creditUsageRecordRespDto.setCreditAccountCode(creditAccountEo.getCreditAccountCode());
                    creditUsageRecordRespDto.setDim1Value(creditAccountEo.getDim1Value());
                    creditUsageRecordRespDto.setDim2Value(creditAccountEo.getDim2Value());
                    creditUsageRecordRespDto.setCreditEntityType((Integer)entityTypeMap.get(creditAccountEo.getCreditEntityId()));
                }
                this.logger.info("\u4fe1\u7528\u660e\u7ec6\u67e5\u8be2\uff0c\u7ec4\u7ec7id\u4e3a[{}]", (Object)creditUsageRecordRespDto.getOrgInfoId());
                if (ObjectUtil.isNotEmpty((Object)creditUsageRecordRespDto.getOrgInfoId())) {
                    customerRespDto = (CustomerRespDto)RestResponseCreditHelper.extractData((RestResponse)this.iCustomerExtQueryApi.queryOneByOrgId(creditUsageRecordRespDto.getOrgInfoId()));
                    this.logger.info("\u4fe1\u7528\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u5230\u5ba2\u6237\u4fe1\u606f\u4e3a[{}]", (Object)JSON.toJSONString((Object)customerRespDto));
                    if (ObjectUtil.isNotEmpty((Object)customerRespDto.getName())) {
                        creditUsageRecordRespDto.setName(customerRespDto.getName());
                    }
                }
                customerRespDto = (CustomerRespDto)RestResponseCreditHelper.extractData((RestResponse)this.iCustomerExtQueryApi.queryOneByOrgId(creditUsageRecordRespDto.getOrgInfoId()));
                this.logger.info("\u4fe1\u7528\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u5230\u5ba2\u6237\u4fe1\u606f\u4e3a[{}]", (Object)JSON.toJSONString((Object)customerRespDto));
                creditUsageRecordRespDto.setName(customerRespDto.getName());
            }
            pageInfo.setList((List)list);
        }
    }

    public CreditUsageRecordRespDto getDetail(Long id) {
        return null;
    }

    @Override
    public List<CreditUsageRecordRespDto> queryFailRecordList() {
        List creditUsageRecordEos = this.creditUsageRecordDas.queryFailRecordList();
        return creditUsageRecordEos.stream().map(this::buildCreditUsageRecordRespDto).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void dealQuotaOver(CreditUsageRecordRespDto creditRecordPageRespDto) {
        CreditUsageRecordEo newCreditUsageRecordEo = new CreditUsageRecordEo();
        newCreditUsageRecordEo.setId(creditRecordPageRespDto.getId());
        newCreditUsageRecordEo.setCreditUsageStatus(CreditUsageStatusEnum.WAIT.getCode());
        List creditUsageRecordEos = this.creditUsageRecordDas.selectList((BaseEo)newCreditUsageRecordEo);
        if (CollectionUtils.isEmpty((Collection)creditUsageRecordEos)) {
            this.logger.info("\u4f7f\u7528\u8bb0\u5f55\u5df2\u5b8c\u6210,\u81ea\u52a8\u9000\u51faUsageRecordNo:" + creditRecordPageRespDto.getUsageRecordNo());
            return;
        }
        this.logger.info("\u63d0\u4ea4\u5931\u8d25\u521b\u5efa\u9000\u4fe1\u7528\u989d\u5ea6\u8bb0\u5f55\u56de\u9000\u4f59\u989d/\u65e7\u8bb0\u5f55\u6539\u4e3a\u6b63\u5e38\u72b6\u6001\u5e76\u65b0\u589e\u9006\u5411\u8bb0\u5f55");
        newCreditUsageRecordEo.setCreditUsageStatus(CreditUsageStatusEnum.GOOD.getCode());
        newCreditUsageRecordEo.setRemark(CreditUsageRecordType.SUBMIT_ORDER.getDesc());
        this.creditUsageRecordDas.updateSelective((BaseEo)newCreditUsageRecordEo);
        CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto = new CreditAccountUpdateQuotaReqDto();
        creditAccountUpdateQuotaReqDto.setCreditAccountId(creditRecordPageRespDto.getCreditAccountId());
        creditAccountUpdateQuotaReqDto.setGrantQuota(creditRecordPageRespDto.getQuota());
        creditAccountUpdateQuotaReqDto.setRemark(CreditUsageRecordType.SUBMIT_ORDER_FAIL.getDesc());
        creditAccountUpdateQuotaReqDto.setCreditAccountUpdateTypeEnum(CreditAccountUpdateTypeEnum.RELEASE);
        creditAccountUpdateQuotaReqDto.setCreditUsageStatus(CreditUsageStatusEnum.GOOD.getCode());
        creditAccountUpdateQuotaReqDto.setOrgInfoId(creditRecordPageRespDto.getOrgInfoId());
        creditAccountUpdateQuotaReqDto.setCreditEntityId(creditRecordPageRespDto.getCustomerId());
        this.iCreditAccountService.useAndReleaseQuota(creditAccountUpdateQuotaReqDto);
    }

    @Override
    public CreditUsageRecordTotalRespDto queryTotal(CreditUsageSearchReqDto searchReqDto) {
        CreditUsageRecordTotalRespDto totalRespDto = new CreditUsageRecordTotalRespDto();
        BigDecimal income = BigDecimal.ZERO;
        BigDecimal disburse = BigDecimal.ZERO;
        searchReqDto.setPageNum(Integer.valueOf(1));
        searchReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<CreditUsageRecordRespDto> pageInfo = this.queryPage(searchReqDto);
        if (ObjectUtil.isNotEmpty(pageInfo) && CollUtil.isNotEmpty((Collection)pageInfo.getList())) {
            for (CreditUsageRecordRespDto respDto : pageInfo.getList()) {
                if (CreditUsageTypeEnum.REMIND.getType().equals(respDto.getUsageType())) {
                    income = income.add(respDto.getQuota());
                    continue;
                }
                if (!CreditUsageTypeEnum.CONTROL.getType().equals(respDto.getUsageType())) continue;
                disburse = disburse.add(respDto.getQuota());
            }
        }
        totalRespDto.setIncome(income);
        totalRespDto.setDisburse(disburse);
        return totalRespDto;
    }

    private CreditUsageRecordRespDto buildCreditUsageRecordRespDto(CreditUsageRecordEo creditUsageRecordEo) {
        CreditUsageRecordRespDto creditUsageRecordRespDto = new CreditUsageRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)creditUsageRecordEo, (BaseVo)creditUsageRecordRespDto);
        creditUsageRecordRespDto.setQuota(creditUsageRecordEo.getQuota());
        return creditUsageRecordRespDto;
    }
}

