/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.AttachmentReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayApplyReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayApplySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayPlanSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayPlansReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PageDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditRepayApplyRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditRepayPlanForRepayRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditRepayPlanRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.ReverseOrderReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRepayPlanStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.GeneralRuleCodeType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditRepayPlanQueryApi;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.engine.action.IAccountQuotaAction;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.IAttachmentService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditRepayApplyService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.GenerateCode;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.AttachmentDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRepayApplyDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRepayPlanDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditEntityEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRepayApplyEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRepayPlanEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditRepayPlanEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchBaseReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CreditRepayApplyServiceImpl
implements ICreditRepayApplyService {
    @Resource
    private IAccountQuotaAction accountQuotaAction;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICreditRepayPlanQueryApi creditRepayPlanQueryApi;
    @Resource
    private AttachmentDas attachmentDas;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private IContext iContext;
    @Resource
    private CreditRepayApplyDas creditRepayApplyDas;
    @Resource
    private CreditEntityDas creditEntityDas;
    @Resource
    private GenerateCode generateCode;
    @Autowired
    private IAttachmentService iAttachmentService;
    @Resource
    private CreditRepayPlanDas creditRepayPlanDas;

    @Override
    @Transactional
    public Long addCreditRepayApply(CreditRepayApplyReqDto addReqDto) {
        CreditRepayApplyEo creditRepayApplyEo = new CreditRepayApplyEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)creditRepayApplyEo);
        this.savePlan(addReqDto.getRefundAmount(), addReqDto.getCreditRepayPlans(), addReqDto.getEntityId(), creditRepayApplyEo);
        this.logger.info(" [\u521b\u5efa\u8fd8\u6b3e\u7533\u8bf7]\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        creditRepayApplyEo.setApplyCode(this.generateCode.createCode(GeneralRuleCodeType.ZD));
        Long orgId = this.getOrgId();
        creditRepayApplyEo.setOrganizationId(orgId);
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        creditRepayApplyEo.setApplyPerson(requestUserCode);
        if (StringUtils.isEmpty((CharSequence)creditRepayApplyEo.getName())) {
            creditRepayApplyEo.setName(addReqDto.getName());
        }
        this.creditRepayApplyDas.insert((BaseEo)creditRepayApplyEo);
        RelateTypeEnum relateTypeEnum = RelateTypeEnum.CREDIT_REPAY;
        this.iAttachmentService.saveAttachment(creditRepayApplyEo.getId(), relateTypeEnum, addReqDto.getAttachmentList());
        return creditRepayApplyEo.getId();
    }

    @Transactional
    public void changeApplyState(List<CreditRepayPlansReqDto> creditRepayPlansReqDtos, String state) {
        Assert.isTrue((!CollectionUtils.isEmpty(creditRepayPlansReqDtos) ? 1 : 0) != 0, (String)"\u8fd8\u6b3e\u8d26\u5355\u4e0d\u80fd\u4e3a\u7a7a:", (Object[])new Object[0]);
        for (CreditRepayPlansReqDto creditRepayPlansReqDto : creditRepayPlansReqDtos) {
            CreditRepayPlanEo creditRepayPlanEo = new CreditRepayPlanEo();
            creditRepayPlanEo.setAuditStatus(state);
            creditRepayPlanEo.setId(creditRepayPlansReqDto.getId());
            this.creditRepayPlanDas.updateSelective((BaseEo)creditRepayPlanEo);
        }
    }

    private void savePlan(BigDecimal amount, List<CreditRepayPlansReqDto> creditRepayPlans, Long entityId, CreditRepayApplyEo creditRepayApplyEo) {
        BigDecimal amounts1 = creditRepayPlans.stream().map(item -> item.getThisRefundAmount() == null ? BigDecimal.ZERO : item.getThisRefundAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        Assert.isTrue((amounts1.compareTo(amount) == 0 ? 1 : 0) != 0, (String)("\u524d\u7aefRefundAmount\u8ba1\u7b97\u5f02\u5e38:\u6c47\u603b\u91d1\u989d\u4e3a" + amounts1), (Object[])new Object[0]);
        String waitAudit = "WAIT_AUDIT";
        CreditEntityEo creditEntityEo = (CreditEntityEo)this.creditEntityDas.selectByPrimaryKey(entityId);
        Assert.notNull((Object)creditEntityEo, (String)("\u627e\u4e0d\u5230\u6388\u4fe1\u4e3b\u4f53entityId:" + entityId), (Object[])new Object[0]);
        Assert.isTrue((0 < creditRepayPlans.size() && creditRepayPlans.size() <= 50 ? 1 : 0) != 0, (String)("\u8d26\u5355\u592a\u591a\u5566,\u8bf7\u5206\u591a\u6b21\u53d1\u8d77\u7533\u8bf7:" + entityId), (Object[])new Object[0]);
        Map group = creditRepayPlans.stream().collect(Collectors.groupingBy(CreditRepayPlansReqDto::getId, Collectors.toList()));
        List creditRepayPlanEos = this.creditRepayPlanDas.selectByIds(new ArrayList<Long>(group.keySet()));
        for (CreditRepayPlanEo creditRepayPlanEo : creditRepayPlanEos) {
            Assert.isTrue((!CollectionUtils.isEmpty((Collection)group.get(creditRepayPlanEo.getId())) ? 1 : 0) != 0, (String)("\u627e\u4e0d\u5230\u8fd8\u6b3e\u8ba1\u5212:" + creditRepayPlanEo.getId()), (Object[])new Object[0]);
            Assert.isTrue((boolean)"NONE".equals(creditRepayPlanEo.getAuditStatus()), (String)("\u8d26\u5355\u5df2\u5728\u5ba1\u6838\u4e2d:" + creditRepayPlanEo.getId()), (Object[])new Object[0]);
            Assert.isTrue((CreditRepayPlanStatusEnum.NOT_RECEIVABLE.getCode().equals(creditRepayPlanEo.getCreditRepayPlanStatus()) || CreditRepayPlanStatusEnum.PART_RECEIVABLE.getCode().equals(creditRepayPlanEo.getCreditRepayPlanStatus()) ? 1 : 0) != 0, (String)("\u8d26\u5355\u72b6\u6001\u5f02\u5e38:" + creditRepayPlanEo.getId()), (Object[])new Object[0]);
            CreditRepayPlanEo newCreditRepayPlanEo = new CreditRepayPlanEo();
            BigDecimal waitRefundAmount = creditRepayPlanEo.getPaidAmount().subtract(creditRepayPlanEo.getReceivedAmount());
            BigDecimal thisRefundAmount = ((CreditRepayPlansReqDto)group.get(creditRepayPlanEo.getId()).get(0)).getThisRefundAmount();
            Assert.isTrue((thisRefundAmount.compareTo(waitRefundAmount) <= 0 ? 1 : 0) != 0, (String)("\u8fd8\u6b3e\u91d1\u989d\u8d85\u51fa\u5566:" + creditRepayPlanEo.getId()), (Object[])new Object[0]);
            newCreditRepayPlanEo.setId(creditRepayPlanEo.getId());
            newCreditRepayPlanEo.setAuditStatus(waitAudit);
            this.creditRepayPlanDas.updateSelective((BaseEo)newCreditRepayPlanEo);
        }
        creditRepayApplyEo.setAuditStatus(waitAudit);
        creditRepayApplyEo.setName(creditEntityEo.getName());
        creditRepayApplyEo.setCreditRepayIds(JSON.toJSONString(creditRepayPlans));
    }

    @Override
    public void modifyCreditRepayApply(CreditRepayApplyReqDto modifyReqDto) {
        Assert.notNull((Object)modifyReqDto.getId(), (String)" id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CreditRepayApplyEo creditRepayApplyEoById = (CreditRepayApplyEo)this.creditRepayApplyDas.selectByPrimaryKey(modifyReqDto.getId());
        Assert.isTrue((creditRepayApplyEoById != null ? 1 : 0) != 0, (String)("\u627e\u4e0d\u5230\u7533\u8bf7\u5355,id:" + modifyReqDto.getId()), (Object[])new Object[0]);
        List creditRepayPlansReqDtos = com.dtyunxi.huieryun.core.util.JSON.parseList((String)creditRepayApplyEoById.getCreditRepayIds(), CreditRepayPlansReqDto.class);
        this.changeWaitApplyPlan(creditRepayApplyEoById, creditRepayPlansReqDtos);
        this.savePlan(modifyReqDto.getRefundAmount(), modifyReqDto.getCreditRepayPlans(), creditRepayApplyEoById.getEntityId(), creditRepayApplyEoById);
        CreditRepayApplyEo newCreditRepayApplyEo = new CreditRepayApplyEo();
        newCreditRepayApplyEo.setId(creditRepayApplyEoById.getId());
        newCreditRepayApplyEo.setRefundAmount(modifyReqDto.getRefundAmount());
        newCreditRepayApplyEo.setRemark(modifyReqDto.getRemark());
        newCreditRepayApplyEo.setAuditStatus(creditRepayApplyEoById.getAuditStatus());
        newCreditRepayApplyEo.setRepayResultJson(null);
        this.creditRepayApplyDas.updateSelective((BaseEo)newCreditRepayApplyEo);
        RelateTypeEnum relateTypeEnum = RelateTypeEnum.CREDIT_REPAY;
        this.iAttachmentService.updateAttachment(modifyReqDto.getId(), relateTypeEnum, modifyReqDto.getAttachmentList());
    }

    private void changeWaitApplyPlan(CreditRepayApplyEo creditRepayApplyEoById, List<CreditRepayPlansReqDto> creditRepayPlansReqDtos) {
        if ("WAIT_AUDIT".equals(creditRepayApplyEoById.getAuditStatus())) {
            for (CreditRepayPlansReqDto creditRepayPlansReqDto : creditRepayPlansReqDtos) {
                CreditRepayPlanEo creditRepayPlanEo = new CreditRepayPlanEo();
                creditRepayPlanEo.setId(creditRepayPlansReqDto.getId());
                creditRepayPlanEo.setAuditStatus("NONE");
                this.creditRepayPlanDas.updateSelective((BaseEo)creditRepayPlanEo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCreditRepayApply(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            Long creditRepayApplyId = Long.valueOf(id);
            CreditRepayApplyEo creditRepayApplyEo = (CreditRepayApplyEo)this.creditRepayApplyDas.selectByPrimaryKey(creditRepayApplyId);
            Assert.notNull((Object)creditRepayApplyEo, (String)("\u627e\u4e0d\u5230\u7533\u8bf7:" + ids), (Object[])new Object[0]);
            Assert.isTrue((!"AUDIT_PASS".equalsIgnoreCase(creditRepayApplyEo.getAuditStatus()) ? 1 : 0) != 0, (String)"\u5df2\u5ba1\u6838\u901a\u8fc7\u4e0d\u5141\u8bb8\u5220\u9664:", (Object[])new Object[0]);
            this.creditRepayApplyDas.logicDeleteById(Long.valueOf(id));
            List collect = com.dtyunxi.huieryun.core.util.JSON.parseList((String)creditRepayApplyEo.getCreditRepayIds(), CreditRepayPlansReqDto.class);
            this.changeWaitApplyPlan(creditRepayApplyEo, collect);
        }
    }

    @Override
    public CreditRepayApplyRespDto queryById(Long id) {
        CreditRepayApplyEo creditRepayApplyEo = (CreditRepayApplyEo)this.creditRepayApplyDas.selectByPrimaryKey(id);
        Assert.notNull((Object)creditRepayApplyEo, (String)"\u627e\u4e0d\u5230\u7533\u8bf7", (Object[])new Object[0]);
        CreditRepayApplyRespDto creditRepayApplyRespDto = new CreditRepayApplyRespDto();
        DtoHelper.eo2Dto((BaseEo)creditRepayApplyEo, (BaseVo)creditRepayApplyRespDto);
        RestResponse customerRespDtoRestResponse = this.iCustomerQueryApi.queryById(creditRepayApplyEo.getEntityId());
        CustomerRespDto data1 = (CustomerRespDto)customerRespDtoRestResponse.getData();
        creditRepayApplyRespDto.setName(data1.getName());
        List attachmentEos = this.attachmentDas.findAttachment(id, RelateTypeEnum.CREDIT_REPAY);
        ArrayList list = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)attachmentEos, list, AttachmentReqDto.class);
        creditRepayApplyRespDto.setAttachmentList(list);
        List creditRepayPlansReqDtos = com.dtyunxi.huieryun.core.util.JSON.parseList((String)creditRepayApplyEo.getCreditRepayIds(), CreditRepayPlansReqDto.class);
        List<CreditRepayPlanRespDto> list1 = this.getCreditRepayPlanSearchReqDtoForPage(creditRepayPlansReqDtos);
        Map group = creditRepayPlansReqDtos.stream().collect(Collectors.groupingBy(CreditRepayPlansReqDto::getId, Collectors.toList()));
        List collect = Optional.ofNullable(list1).orElse(Lists.newArrayList()).stream().map(data -> {
            CreditRepayPlanForRepayRespDto newData = new CreditRepayPlanForRepayRespDto();
            BeanUtils.copyProperties((Object)data, (Object)newData);
            BigDecimal thisRefundAmount = CollectionUtils.isEmpty((Collection)((Collection)group.get(data.getId()))) ? BigDecimal.ZERO : ((CreditRepayPlansReqDto)((List)group.get(data.getId())).get(0)).getThisRefundAmount();
            newData.setThisRefundAmount(thisRefundAmount);
            return newData;
        }).collect(Collectors.toList());
        creditRepayApplyRespDto.setCreditRepayPlanList(collect);
        return creditRepayApplyRespDto;
    }

    private List<CreditRepayPlanEo> getCreditRepayPlanSearchReqDto(String ids) {
        CreditRepayPlanEo creditRepayPlanEo = new CreditRepayPlanEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        List collect = Arrays.stream(ids.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(collect)) {
            sqlFilterList.add(SqlFilter.in((String)"id", collect));
        }
        creditRepayPlanEo.setSqlFilters(sqlFilterList);
        PageInfo creditRepayPlanEoPageInfo = this.creditRepayPlanDas.selectPage((BaseEo)creditRepayPlanEo, Integer.valueOf(1), Integer.valueOf(5000));
        return creditRepayPlanEoPageInfo.getList();
    }

    private List<CreditRepayPlanRespDto> getCreditRepayPlanSearchReqDtoForPage(List<CreditRepayPlansReqDto> ids) {
        List collect = ids.stream().map(CreditRepayPlansReqDto::getId).collect(Collectors.toList());
        CreditRepayPlanSearchReqDto creditRepayPlanSearchReqDto = new CreditRepayPlanSearchReqDto();
        creditRepayPlanSearchReqDto.setIds(collect);
        creditRepayPlanSearchReqDto.setPageNum(Integer.valueOf(1));
        creditRepayPlanSearchReqDto.setPageSize(Integer.valueOf(1000));
        RestResponse restResponse = this.creditRepayPlanQueryApi.queryPage((PageDto)creditRepayPlanSearchReqDto);
        return ((PageInfo)restResponse.getData()).getList();
    }

    public HashMap<Long, BigDecimal> apportionAmount(List<CreditRepayPlanEo> repayPlanEoList, BigDecimal receivedAmount) {
        List collectBySort = repayPlanEoList.stream().sorted(Comparator.comparing(StdCreditRepayPlanEo::getEndDate)).collect(Collectors.toList());
        HashMap<Long, BigDecimal> hashMapLongBigDecimal = new HashMap<Long, BigDecimal>();
        for (CreditRepayPlanEo creditRepayPlanEo : collectBySort) {
            if (receivedAmount.compareTo(BigDecimal.valueOf(0L)) < 1) break;
            BigDecimal waitAmount = creditRepayPlanEo.getOccupyQuota().subtract(creditRepayPlanEo.getReceivedAmount()).subtract(creditRepayPlanEo.getRefundAmount());
            BigDecimal amount = waitAmount.min(receivedAmount);
            hashMapLongBigDecimal.put(creditRepayPlanEo.getId(), amount);
            receivedAmount = receivedAmount.subtract(amount);
        }
        return hashMapLongBigDecimal;
    }

    @Override
    public PageInfo<CreditRepayApplyRespDto> queryByPage(CreditRepayApplySearchReqDto creditRepayApplyReqDto, Integer pageNum, Integer pageSize) {
        List creditEntityEos;
        Long orgId;
        CreditRepayApplyEo creditRepayApplyEo = new CreditRepayApplyEo();
        DtoHelper.dto2Eo((BaseVo)creditRepayApplyReqDto, (BaseEo)creditRepayApplyEo);
        List<Long> entityIds = this.getCustomer();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        QueryWrapper eq = (QueryWrapper)new QueryWrapper().eq((Object)"dr", (Object)0);
        if (StringUtils.isNotBlank((CharSequence)creditRepayApplyReqDto.getCustomerCode()) || StringUtils.isNotBlank((CharSequence)creditRepayApplyReqDto.getCustomerName())) {
            CustomerSearchBaseReqDto customerSearchBaseReqDto = new CustomerSearchBaseReqDto();
            customerSearchBaseReqDto.setCustomerName(creditRepayApplyReqDto.getCustomerName());
            customerSearchBaseReqDto.setCustomerCode(creditRepayApplyReqDto.getCustomerCode());
            RestResponse listRestResponse = this.iCustomerQueryApi.queryIdsBySingleFilter(customerSearchBaseReqDto);
            List customerIds = (List)listRestResponse.getData();
            entityIds = entityIds.stream().filter(customerIds::contains).collect(Collectors.toList());
            eq.in((Object)"entity_Id", entityIds);
        }
        if (Objects.nonNull(orgId = this.getOrgId())) {
            eq.eq((Object)"org_info_id", (Object)orgId);
        }
        if (CollectionUtils.isEmpty((Collection)(creditEntityEos = this.creditEntityDas.getMapper().selectList((Wrapper)eq)))) {
            return new PageInfo();
        }
        entityIds = creditEntityEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        sqlFilterList.add(SqlFilter.in((String)"entity_Id", entityIds));
        if (StringUtils.isNotEmpty((CharSequence)creditRepayApplyReqDto.getCreateTimeStart()) && StringUtils.isNotEmpty((CharSequence)creditRepayApplyReqDto.getCreateTimeEnd())) {
            sqlFilterList.add(SqlFilter.ge((String)"create_time", (Object)creditRepayApplyReqDto.getCreateTimeStart()));
            sqlFilterList.add(SqlFilter.le((String)"create_time", (Object)creditRepayApplyReqDto.getCreateTimeEnd()));
        }
        creditRepayApplyEo.setSqlFilters(sqlFilterList);
        creditRepayApplyEo.setOrganizationId(orgId);
        creditRepayApplyEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.creditRepayApplyDas.selectPage((BaseEo)creditRepayApplyEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List collectCreditRepayApplyRespDto = eoPageInfo.getList().stream().map(data -> {
            CreditRepayApplyRespDto newData = new CreditRepayApplyRespDto();
            BeanUtils.copyProperties((Object)data, (Object)newData);
            return newData;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(collectCreditRepayApplyRespDto);
        return dtoPageInfo;
    }

    private List<Long> getCustomer() {
        RestResponse listRestResponse = this.iCustomerExtQueryApi.queryCustomerIdsByUserId(this.iContext.userId());
        return (List)listRestResponse.getData();
    }

    private Long getOrgId() {
        RestResponse longRestResponse = this.iCustomerExtQueryApi.queryOrgIdByUserId(this.iContext.userId());
        return (Long)longRestResponse.getData();
    }

    @Override
    @Transactional
    public Long auditCreditRepayApply(CreditRepayApplyReqDto addReqDto) {
        this.logger.info(" [\u56de\u6b3e \u5165\u53c2]\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        CreditRepayApplyEo creditRepayApplyEo = (CreditRepayApplyEo)this.creditRepayApplyDas.selectByPrimaryKey(addReqDto.getId());
        Assert.isTrue((boolean)"WAIT_AUDIT".equalsIgnoreCase(creditRepayApplyEo.getAuditStatus()), (String)"\u5df2\u5ba1\u6838,\u8bf7\u52ff\u91cd\u590d\u5ba1\u6838", (Object[])new Object[0]);
        List collect = com.dtyunxi.huieryun.core.util.JSON.parseList((String)creditRepayApplyEo.getCreditRepayIds(), CreditRepayPlansReqDto.class);
        if ("AUDIT_PASS".equalsIgnoreCase(addReqDto.getAuditStatus())) {
            ReverseOrderReq reverseOrderReq = new ReverseOrderReq();
            reverseOrderReq.setCustomerId(creditRepayApplyEo.getEntityId());
            reverseOrderReq.setIsRefund(Integer.valueOf(1));
            reverseOrderReq.setFormCode(creditRepayApplyEo.getApplyCode());
            reverseOrderReq.setReceiveType(Integer.valueOf(1));
            reverseOrderReq.setRemark(addReqDto.getRemark());
            reverseOrderReq.setCreditRepayPlan(collect);
            this.logger.info(" [\u91ca\u653e\u989d\u5ea6]\uff1a{}", (Object)JSON.toJSONString((Object)reverseOrderReq));
            this.accountQuotaAction.releaseQuota(reverseOrderReq);
            HashMap<Long, BigDecimal> hashMapLongBigDecimal = new HashMap<Long, BigDecimal>();
            for (CreditRepayPlansReqDto creditRepayPlansReqDto : collect) {
                hashMapLongBigDecimal.put(creditRepayPlansReqDto.getId(), creditRepayPlansReqDto.getThisRefundAmount());
            }
            creditRepayApplyEo.setRepayResultJson(JSON.toJSONString(hashMapLongBigDecimal));
        }
        this.changeApplyState(collect, "NONE");
        CreditRepayApplyEo newCreditRepayApplyEo = new CreditRepayApplyEo();
        newCreditRepayApplyEo.setId(creditRepayApplyEo.getId());
        newCreditRepayApplyEo.setAuditStatus(addReqDto.getAuditStatus());
        this.creditRepayApplyDas.updateSelective((BaseEo)newCreditRepayApplyEo);
        return creditRepayApplyEo.getId();
    }
}

