/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayPlanSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditRepayPlanRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRepayPlanStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.YesOrNoStatus;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.RestResponseCreditHelper;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditRepayPlanService;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDetailDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditNodeDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRepayPlanDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditEntityDetailEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRepayPlanEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditEntityDetailEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="creditRepayPlan")
public class CreditRepayPlanServiceImpl
implements ICreditRepayPlanService {
    @Resource
    private IContext iContext;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private CreditRepayPlanDas creditRepayPlanDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Resource
    private CreditNodeDas creditNodeDas;
    @Resource
    private CreditEntityDetailDas creditEntityDetailDas;
    @Resource
    private CreditEntityDas creditEntityDas;

    public PageInfo<CreditRepayPlanRespDto> queryPage(CreditRepayPlanSearchReqDto searchReqDto) {
        PageInfo pageInfo = new PageInfo();
        List accountIds = null;
        List<CreditAccountEo> accountEoList = this.filter(searchReqDto);
        if (accountEoList == null) {
            return pageInfo;
        }
        accountIds = accountEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        String start = null;
        String end = null;
        if (null != searchReqDto.getDue1() && null != searchReqDto.getDue2()) {
            Calendar cl = Calendar.getInstance();
            cl.setTime(new Date());
            cl.add(5, -searchReqDto.getDue2().intValue());
            start = DateUtil.format((Date)cl.getTime());
            cl.setTime(new Date());
            cl.add(5, -searchReqDto.getDue1().intValue() + 1);
            end = DateUtil.format((Date)cl.getTime());
        }
        PageHelper.startPage((int)searchReqDto.getPageNum(), (int)searchReqDto.getPageSize());
        PageInfo select = new PageInfo(this.creditRepayPlanDas.searchPage(accountIds, searchReqDto, start, end));
        this.joinList((PageInfo<CreditRepayPlanRespDto>)pageInfo, accountEoList, (PageInfo<CreditRepayPlanEo>)select);
        return pageInfo;
    }

    private List<CreditAccountEo> filter(CreditRepayPlanSearchReqDto searchReqDto) {
        List creditAccountEolist = Lists.newArrayList();
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        List<CreditEntityDetailEo> entityDetailEoList = this.findByFilter(searchReqDto);
        if (entityDetailEoList == null) {
            return null;
        }
        List entityIds = entityDetailEoList.stream().map(StdCreditEntityDetailEo::getCreditEntityId).collect(Collectors.toList());
        if (!StringUtils.isBlank((CharSequence)searchReqDto.getCreditAccountCode())) {
            creditAccountEo.setCreditAccountCode(searchReqDto.getCreditAccountCode());
        }
        if ("N".equalsIgnoreCase(searchReqDto.getIsMang())) {
            ArrayList<Long> list = new ArrayList<Long>();
            if (searchReqDto.getOrgId() == null) {
                Long orgId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData();
                list.add(orgId);
            } else {
                list.add(searchReqDto.getOrgId());
            }
            RestResponse customerIdsRestResponse = this.iCustomerExtQueryApi.queryCustomerIdByOrgId(list);
            entityIds.addAll((Collection)customerIdsRestResponse.getData());
        } else {
            RestResponse customerIdsRestResponse = this.iCustomerExtQueryApi.queryOrgIdByUserId(this.iContext.userId());
            creditAccountEo.setOrgInfoId((Long)customerIdsRestResponse.getData());
        }
        if ("N".equalsIgnoreCase(searchReqDto.getIsMang()) && CollectionUtils.isEmpty(entityIds)) {
            return null;
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(entityIds)) {
            sqlFilterList.add(SqlFilter.in((String)"credit_entity_id", entityIds));
        }
        creditAccountEo.setSqlFilters(sqlFilterList);
        List select = this.creditAccountDas.select((BaseEo)creditAccountEo);
        creditAccountEolist = !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)select) ? select : null;
        return creditAccountEolist;
    }

    private List<CreditEntityDetailEo> findByFilter(CreditRepayPlanSearchReqDto searchReqDto) {
        List<Object> list = new ArrayList<CreditEntityDetailEo>();
        if (null != searchReqDto.getCreditEntityId() || StringUtils.isNotEmpty((CharSequence)searchReqDto.getCustomerCode()) || StringUtils.isNotEmpty((CharSequence)searchReqDto.getCustomerName())) {
            List select;
            CreditEntityDetailEo creditEntityDetailEo = new CreditEntityDetailEo();
            if (null != searchReqDto.getCreditEntityId()) {
                creditEntityDetailEo.setCustomerId(searchReqDto.getCreditEntityId());
            }
            if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getCustomerCode())) {
                creditEntityDetailEo.setCustomerCode(searchReqDto.getCustomerCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getCustomerName())) {
                creditEntityDetailEo.setSqlFilters(Collections.singletonList(SqlFilter.like((String)"customer_name", (Object)("%" + searchReqDto.getCustomerName() + "%"))));
            }
            list = !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(select = this.creditEntityDetailDas.select((BaseEo)creditEntityDetailEo))) ? select : null;
        }
        return list;
    }

    private void joinList(PageInfo<CreditRepayPlanRespDto> pageInfo, List<CreditAccountEo> accountEoList, PageInfo<CreditRepayPlanEo> select) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)select.getList())) {
            ArrayList list = Lists.newArrayList();
            BeanUtils.copyProperties(select, pageInfo, (String[])new String[]{"list"});
            Map entityTypeMap = Maps.newHashMap();
            HashMap accountEoMap = Maps.newHashMap();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(accountEoList)) {
                entityTypeMap = this.creditEntityDas.queryEntityTypeByIds(accountEoList.stream().map(StdCreditAccountEo::getCreditEntityId).collect(Collectors.toList()));
                for (CreditAccountEo creditAccountEo : accountEoList) {
                    accountEoMap.put(creditAccountEo.getId(), creditAccountEo);
                }
            }
            for (CreditRepayPlanEo repayPlanEo : select.getList()) {
                CreditRepayPlanRespDto dto = new CreditRepayPlanRespDto();
                DtoHelper.eo2Dto((BaseEo)repayPlanEo, (BaseVo)dto);
                CreditAccountEo creditAccountEo = null;
                if (accountEoMap.containsKey(repayPlanEo.getCreditAccountId())) {
                    creditAccountEo = (CreditAccountEo)accountEoMap.get(repayPlanEo.getCreditAccountId());
                }
                this.handDto(dto, repayPlanEo, creditAccountEo, entityTypeMap);
                list.add(dto);
            }
            pageInfo.setList((List)list);
        }
    }

    public CreditRepayPlanRespDto getDetail(Long id) {
        CreditRepayPlanRespDto dto = new CreditRepayPlanRespDto();
        CreditRepayPlanEo eo = (CreditRepayPlanEo)this.creditRepayPlanDas.selectByPrimaryKey(id);
        if (eo == null) {
            return dto;
        }
        CreditAccountEo creditAccountEo = (CreditAccountEo)this.creditAccountDas.selectByPrimaryKey(eo.getCreditAccountId());
        Map creditEntityTypeMap = Maps.newHashMap();
        if (creditAccountEo != null) {
            creditEntityTypeMap = this.creditEntityDas.queryEntityTypeByIds(Arrays.asList(creditAccountEo.getCreditEntityId()));
        }
        this.handDto(dto, eo, creditAccountEo, creditEntityTypeMap);
        return dto;
    }

    private void handDto(CreditRepayPlanRespDto dto, CreditRepayPlanEo repayPlanEo, CreditAccountEo creditAccountEo, Map<Long, Integer> creditEntityTypeMap) {
        List creditEntityDetailEos;
        DtoHelper.eo2Dto((BaseEo)repayPlanEo, (BaseVo)dto);
        String startTime = null == repayPlanEo.getStartDate() ? null : DateUtil.format((Date)repayPlanEo.getStartDate(), (String)"yyyy-MM-dd");
        String endTime = null == repayPlanEo.getEndDate() ? null : DateUtil.format((Date)repayPlanEo.getEndDate(), (String)"yyyy-MM-dd");
        dto.setStartDate(startTime);
        dto.setEndDate(endTime);
        BigDecimal refundAmount = repayPlanEo.getRefundAmount() == null ? BigDecimal.ZERO : repayPlanEo.getRefundAmount();
        BigDecimal receivedAmount = repayPlanEo.getReceivedAmount() == null ? BigDecimal.ZERO : repayPlanEo.getReceivedAmount();
        BigDecimal subtract = repayPlanEo.getOccupyQuota().subtract(refundAmount).subtract(receivedAmount);
        dto.setReceivableAmount(subtract.max(BigDecimal.ZERO));
        dto.setRefundAmount(refundAmount);
        if (creditAccountEo != null) {
            dto.setDim1Value(creditAccountEo.getDim1Value());
            dto.setDim2Value(creditAccountEo.getDim2Value());
            dto.setCreditAccountCode(creditAccountEo.getCreditAccountCode());
            dto.setCreditEntityType(creditEntityTypeMap.get(creditAccountEo.getCreditEntityId()));
            dto.setCreditEntityId(creditAccountEo.getCreditEntityId());
        }
        dto.setBeginDateTypeName(repayPlanEo.getBeginDateType());
        if (null != repayPlanEo.getFinalOverdueDateNum()) {
            dto.setIsOverdue(YesOrNoStatus.YES_STATUS.getStatus());
            dto.setOverdueTime(repayPlanEo.getFinalOverdueDateNum());
        }
        if (!CreditRepayPlanStatusEnum.RECEIVABLE.getCode().equals(repayPlanEo.getCreditRepayPlanStatus())) {
            Long time = (new Date().getTime() - repayPlanEo.getEndDate().getTime()) / 86400000L;
            dto.setIsOverdue(time > 0L ? YesOrNoStatus.YES_STATUS.getStatus() : YesOrNoStatus.NO_STATUS.getStatus());
            dto.setOverdueTime(Integer.valueOf(time > 0L ? time.intValue() : 0));
        }
        if (repayPlanEo.getCustomerId() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(creditEntityDetailEos = this.creditEntityDetailDas.queryByCustomerId(repayPlanEo.getCustomerId())))) {
            CreditEntityDetailEo creditEntityDetailEo = (CreditEntityDetailEo)creditEntityDetailEos.get(0);
            dto.setCustomerCode(creditEntityDetailEo.getCustomerCode());
            dto.setCustomerName(creditEntityDetailEo.getCustomerName());
        }
        if (ObjectUtil.isNotEmpty((Object)repayPlanEo.getOrgInfoId())) {
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseCreditHelper.extractData((RestResponse)this.iCustomerExtQueryApi.queryOneByOrgId(repayPlanEo.getOrgInfoId()));
            this.logger.info("orgInfoId={}, \u4fe1\u7528\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u5230\u5ba2\u6237\u4fe1\u606f\u4e3a[{}]", (Object)repayPlanEo.getOrgInfoId(), (Object)JSON.toJSONString((Object)customerRespDto));
            if (ObjectUtil.isNotEmpty((Object)customerRespDto.getName())) {
                dto.setName(customerRespDto.getName());
            }
        }
    }

    @Override
    public BigDecimal queryTotal(CreditRepayPlanSearchReqDto searchReqDto) {
        BigDecimal total = BigDecimal.ZERO;
        searchReqDto.setPageNum(Integer.valueOf(1));
        searchReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<CreditRepayPlanRespDto> pageInfo = this.queryPage(searchReqDto);
        if (ObjectUtil.isNotEmpty(pageInfo) && CollUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List list = pageInfo.getList();
            for (CreditRepayPlanRespDto dto : list) {
                total = total.add(dto.getOccupyQuota());
            }
        }
        return total;
    }
}

