/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.dao.credit.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRecordSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.mapper.CreditRecordMapper;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRecordEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CreditRecordDas
extends AbstractBaseDas<CreditRecordEo, String> {
    @Resource
    private CreditRecordMapper creditRecordMapper;

    BigDecimal countGrantQuotaByEntityId(Long entityId) {
        return this.creditRecordMapper.countGrantQuotaByEntityId(entityId, new Date());
    }

    public List<CreditRecordEo> findByApplyId(Long applyId) {
        CreditRecordEo selectItemCreditRecord = new CreditRecordEo();
        selectItemCreditRecord.setCreditApplyId(applyId);
        return this.selectList((BaseEo)selectItemCreditRecord);
    }

    public CreditRecordEo findFirstRecord(Long entityId) {
        return this.creditRecordMapper.findFirstRecord(entityId);
    }

    public List<CreditRecordEo> pageCreditRecord(CreditRecordSearchReqDto creditRecordSearchReqDto) {
        return this.creditRecordMapper.pageCreditRecord(creditRecordSearchReqDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addRecordQuota(Long creditRecordId, BigDecimal grantQuota) {
        this.creditRecordMapper.addRecordQuota(creditRecordId, grantQuota);
    }

    @Transactional(rollbackFor={Exception.class})
    public void useRecordQuota(Long creditRecordId, BigDecimal useQuota) {
        if (useQuota.compareTo(BigDecimal.ZERO) < 0) {
            useQuota = useQuota.negate();
        }
        this.creditRecordMapper.useRecordQuota(creditRecordId, useQuota);
    }

    public List<CreditRecordEo> findEffectRecordByAccount(Long creditAccountId) {
        CreditRecordEo selectItemCreditRecord = new CreditRecordEo();
        ArrayList sqlFilterList = new ArrayList();
        selectItemCreditRecord.setCreditAccountId(creditAccountId);
        selectItemCreditRecord.setCreditRecordStatus(CreditRecordStatusEnum.GOOD.getCode());
        selectItemCreditRecord.setDr(0);
        selectItemCreditRecord.setSqlFilters(sqlFilterList);
        selectItemCreditRecord.setOrderBy("endDate");
        return this.selectList((BaseEo)selectItemCreditRecord);
    }
}

