/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.dao.credit.das;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityCustomerReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.mapper.CreditEntityDetailMapper;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.mapper.CreditEntityMapper;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditEntityEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class CreditEntityDas
extends AbstractBaseDas<CreditEntityEo, String> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private CreditEntityMapper creditEntityMapper;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Resource
    private CreditEntityDetailMapper creditEntityDetailMapper;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private IContext iContext;

    public PageInfo<CreditEntityPageRespDto> pageCreditEntity(CreditEntitySearchReqDto creditEntitySearchReqDto, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        this.logger.info("\u6388\u4fe1\u5ba2\u6236\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)creditEntitySearchReqDto));
        List<CreditEntityPageRespDto> dtoPageInfo = this.creditEntityMapper.pageCreditEntity(creditEntitySearchReqDto);
        for (CreditEntityPageRespDto creditEntityPageRespDto : dtoPageInfo) {
            Integer num = this.creditAccountDas.countAccountNum(creditEntityPageRespDto.getId());
            BigDecimal usedAccount = this.creditAccountDas.countUsedAccountAmount(creditEntityPageRespDto.getId());
            BigDecimal totalAccount = this.creditAccountDas.countTotalAccountAmount(creditEntityPageRespDto.getId());
            creditEntityPageRespDto.setCreditTotalQuota(totalAccount);
            creditEntityPageRespDto.setValidCreditQuota(totalAccount.subtract(usedAccount));
            creditEntityPageRespDto.setAccountNum(num);
            creditEntityPageRespDto.setCreateTimeString(DateTimeUtils.convertDateTimeToString((Date)creditEntityPageRespDto.getCreateTime()));
        }
        return new PageInfo(dtoPageInfo);
    }

    public CreditEntityEo findByEntityId(Long entityId) {
        CreditEntityEo selectItem = new CreditEntityEo();
        selectItem.setId(entityId);
        selectItem.setDr(0);
        return (CreditEntityEo)this.selectOne((BaseEo)selectItem);
    }

    public CreditEntityEo findByEntityCode(String code) {
        CreditEntityEo selectItem = new CreditEntityEo();
        selectItem.setCode(code);
        selectItem.setDr(0);
        return (CreditEntityEo)this.selectOne((BaseEo)selectItem);
    }

    public List<CreditEntityEo> findByEntityCodes(List<String> codes) {
        CreditEntityEo selectItem = new CreditEntityEo();
        selectItem.setDr(0);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"code", codes));
        selectItem.setSqlFilters(sqlFilterList);
        this.selectList((BaseEo)selectItem);
        return this.selectList((BaseEo)selectItem);
    }

    public void updateCreditEntityCreateTime(Date time, String code) {
        this.creditEntityMapper.updateCreditEntityCreateTime(time, code);
    }

    public List<Long> getEnableCustomerIds(Long orgId, String entityType, Long tenantId, Long instanceId) {
        RestResponse customerIdsRestResponse = this.iCustomerExtQueryApi.querySubCustomerListByOrgIds(Arrays.asList(orgId));
        List data = (List)customerIdsRestResponse.getData();
        List<Long> collect = data.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        return this.creditEntityMapper.getEnableCustomerIds(collect, entityType, tenantId, instanceId);
    }

    public Integer countByCustomerIdAndDrAndEntityType(CreditEntityCustomerReqDto creditEntityCustomerReqDto) {
        return this.creditEntityDetailMapper.countByCustomerIdAndDrAndEntityType(creditEntityCustomerReqDto);
    }

    public List<CreditEntityEo> findByEntityMessage(CreditEntityCustomerReqDto creditEntityCustomerReqDto) {
        return this.creditEntityMapper.findByEntityMessage(creditEntityCustomerReqDto);
    }

    public Set<Long> getFilterEntityIds(Integer limitAdd) {
        return this.creditEntityMapper.getFilterEntityIds(limitAdd);
    }

    public List<CreditEntityEo> queryEntityByIds(List<Long> creditEntityIds) {
        CreditEntityEo creditEntityEo = new CreditEntityEo();
        creditEntityEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", creditEntityIds)));
        return this.select((BaseEo)creditEntityEo);
    }

    public Map<Long, Integer> queryEntityTypeByIds(List<Long> creditEntityIds) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(creditEntityIds.size());
        List<CreditEntityEo> list = this.queryEntityByIds(creditEntityIds);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            for (CreditEntityEo creditEntityEo : list) {
                map.put(creditEntityEo.getId(), creditEntityEo.getType());
            }
        }
        return map;
    }

    public List<String> selectCodesByIds(List<Long> customerIds) {
        return this.creditEntityMapper.selectCodesByIds(customerIds);
    }
}

