/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.dao.credit.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.RelevanceType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.YesOrNoStatus;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.mapper.CreditNodeMapper;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditNodeEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository
public class CreditNodeDas
extends AbstractBaseDas<CreditNodeEo, String> {
    @Resource
    private CreditNodeMapper creditNodeMapper;

    public List<CreditNodeEo> queryNodeListByIds(List<Long> ids) {
        CreditNodeEo creditNodeEo = new CreditNodeEo();
        creditNodeEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", ids)));
        return this.select((BaseEo)creditNodeEo);
    }

    public List<CreditNodeEo> queryNodeListByType(String type) {
        CreditNodeEo creditNodeEo = new CreditNodeEo();
        RelevanceType relevanceType = RelevanceType.getType((String)type);
        if (null != relevanceType) {
            creditNodeEo.setSqlFilters(Collections.singletonList(SqlFilter.eq((String)type, (Object)YesOrNoStatus.YES_STATUS.getStatus())));
        }
        return this.select((BaseEo)creditNodeEo);
    }

    public List<CreditNodeEo> queryNodeListByName(String name, String type) {
        CreditNodeEo creditNodeEo = new CreditNodeEo();
        creditNodeEo.setName(name);
        RelevanceType relevanceType = RelevanceType.getType((String)type);
        if (null != relevanceType) {
            creditNodeEo.setSqlFilters(Collections.singletonList(SqlFilter.eq((String)type, (Object)YesOrNoStatus.YES_STATUS.getStatus())));
        }
        PageInfo creditNodeEoPageInfo = this.selectPage((BaseEo)creditNodeEo, 1, 5000);
        return creditNodeEoPageInfo.getList();
    }

    public Map<Long, List<CreditNodeEo>> findCreditNameCode(List<Long> creditNodeIds) {
        CreditNodeEo selectItemCreditNode = new CreditNodeEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", creditNodeIds));
        selectItemCreditNode.setSqlFilters(sqlFilterList);
        selectItemCreditNode.setDr(0);
        List creditRecordEos = this.selectList((BaseEo)selectItemCreditNode);
        return creditRecordEos.stream().collect(Collectors.groupingBy(BaseEo::getId, Collectors.toList()));
    }
}

