/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum AmountTypeEnum {
    ORIGIN("origin", "\u539f\u5355\u5546\u5bb6\u5e94\u6536\u91d1\u989d"),
    CHILD("child", "\u5b50\u5355\u5546\u5bb6\u5e94\u6536\u91d1\u989d");

    public final String code;
    public final String desc;
    public static final Map<String, AmountTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private AmountTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AmountTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(AmountTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(AmountTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

