/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.center.source.api.constant.SourceFindOptTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.center.source.api.dto.request.SourceLogDetailReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.SourceLogReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceLogDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderResultRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IOrderItemResultService;
import com.dtyunxi.cube.center.source.biz.service.IOrderService;
import com.dtyunxi.cube.center.source.biz.service.ISourceLogDetailService;
import com.dtyunxi.cube.center.source.biz.service.ISourceLogService;
import com.dtyunxi.cube.center.source.biz.service.SourceOrderOperation;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderExecutor;
import com.dtyunxi.cube.center.source.biz.vo.SourceOrderExecuteResultVo;
import com.dtyunxi.cube.center.source.dao.eo.OrderEo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SourceOrderOperationImpl
implements SourceOrderOperation {
    private static final Logger logger = LoggerFactory.getLogger(SourceOrderOperationImpl.class);
    @Resource
    private IOrderService orderService;
    @Resource
    private IOrderItemResultService orderItemResultService;
    @Resource
    private SourceOrderExecutor sourceOrderExecutor;
    @Resource
    private ISourceLogService sourceLogService;
    @Resource
    private ISourceLogDetailService sourceLogDetailService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SourceOrderResultRespDto operationSourceOrder(Long sgOrderId) {
        SourceAssert.notNull((Object)sgOrderId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u5355id"});
        OrderDetailRespDto orderDetailRespDto = this.orderService.queryDetailById(sgOrderId);
        this.optimisticModifyOrderSourcing(orderDetailRespDto);
        Long logId = this.saveSourceOptLog(orderDetailRespDto);
        SourceOrderExecuteResultVo sourceOrderExecuteResultVo = this.sourceOrderExecutor.executeSourcing(orderDetailRespDto);
        this.updateSourceOptLog(sourceOrderExecuteResultVo, logId);
        SourceAssert.notNull((Object)sourceOrderExecuteResultVo.getSourceOrderResultRespDto(), (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u83b7\u53d6\u4e0d\u5230\u5bfb\u6e90\u7ed3\u679c"});
        if (sourceOrderExecuteResultVo.getSourceOrderResultRespDto().getSgStatus().equals(SourceStatusEnum.SOURCE_SUCCESS.getCode())) {
            this.orderItemResultService.addOrderItemResultRespList(sourceOrderExecuteResultVo.getSourceOrderResultRespDto().getOrderItemResultRespDtoList());
            this.optimisticModifyOrderSuccess(orderDetailRespDto);
        } else {
            this.optimisticModifyOrderFail(orderDetailRespDto, sourceOrderExecuteResultVo.getSourceOrderResultRespDto().getSgFailResultDesc());
        }
        return sourceOrderExecuteResultVo.getSourceOrderResultRespDto();
    }

    private void optimisticModifyOrderSourcing(OrderDetailRespDto orderDetailRespDto) {
        logger.info("optimisticModifyOrderSourcing\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)orderDetailRespDto));
        if (SourceStatusEnum.SOURCING.getCode().equals(orderDetailRespDto.getSgStatus())) {
            return;
        }
        OrderEo updateEo = new OrderEo();
        updateEo.setId(orderDetailRespDto.getId());
        updateEo.setSgStatus(SourceStatusEnum.SOURCING.getCode());
        OrderEo queryEo = new OrderEo();
        queryEo.setId(orderDetailRespDto.getId());
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"sg_status", new Object[]{SourceStatusEnum.WAIT_SOURCE.getCode()});
        this.orderService.optimisticModifyOrderEo(updateEo, (UpdateWrapper<OrderEo>)updateWrapper, 1, true);
    }

    private void optimisticModifyOrderSuccess(OrderDetailRespDto orderDetailRespDto) {
        OrderEo updateEo = new OrderEo();
        updateEo.setId(orderDetailRespDto.getId());
        updateEo.setSgStatus(SourceStatusEnum.SOURCE_SUCCESS.getCode());
        OrderEo queryEo = new OrderEo();
        queryEo.setId(orderDetailRespDto.getId());
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.eq((Object)"sg_status", (Object)SourceStatusEnum.SOURCING);
        this.orderService.optimisticModifyOrderEo(updateEo, (UpdateWrapper<OrderEo>)updateWrapper, 1, true);
    }

    private void optimisticModifyOrderFail(OrderDetailRespDto orderDetailRespDto, String sgFailResultDesc) {
        OrderEo updateEo = new OrderEo();
        updateEo.setId(orderDetailRespDto.getId());
        updateEo.setSgStatus(SourceStatusEnum.SOURCE_FAIL.getCode());
        updateEo.setSgFailResultDesc(sgFailResultDesc);
        OrderEo queryEo = new OrderEo();
        queryEo.setId(orderDetailRespDto.getId());
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.eq((Object)"sg_status", (Object)SourceStatusEnum.SOURCING);
        this.orderService.optimisticModifyOrderEo(updateEo, (UpdateWrapper<OrderEo>)updateWrapper, 1, true);
    }

    private long saveSourceOptLog(OrderDetailRespDto orderDetailRespDto) {
        SourceLogReqDto sourceLogReqDto = new SourceLogReqDto();
        CubeBeanUtils.copyProperties((Object)sourceLogReqDto, (Object)orderDetailRespDto, (String[])new String[0]);
        sourceLogReqDto.setId(null);
        sourceLogReqDto.setSgStatus(SourceStatusEnum.SOURCING.getCode());
        sourceLogReqDto.setSgOrderId(orderDetailRespDto.getId());
        sourceLogReqDto.setSgVoucherNo(UUID.randomUUID().toString());
        return this.sourceLogService.addSourceLog(sourceLogReqDto);
    }

    private void updateSourceOptLog(SourceOrderExecuteResultVo sourceOrderExecuteResultVo, Long logId) {
        List<SourceLogDetailRespDto> logDetailRespDtoList = sourceOrderExecuteResultVo.getSourceExecuteContextVo().getSourceLogDetailRespDtoList();
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(logDetailRespDtoList)) {
            List addReqDtoList = logDetailRespDtoList.stream().map(dto -> {
                SourceLogDetailReqDto sourceLogDetailReqDto = new SourceLogDetailReqDto();
                CubeBeanUtils.copyProperties((Object)sourceLogDetailReqDto, (Object)dto, (String[])new String[0]);
                sourceLogDetailReqDto.setId(null);
                sourceLogDetailReqDto.setSgFindLogId(logId);
                if (dto.getSgFindOptType().equals(SourceFindOptTypeEnum.SOURCE_ACCESS_WAREHOUSE.getCode())) {
                    stringBuilder.append(dto.getSgFindOptResult());
                }
                return sourceLogDetailReqDto;
            }).collect(Collectors.toList());
            this.sourceLogDetailService.addSourceLogDetailList(addReqDtoList);
        }
        SourceLogReqDto updateDto = new SourceLogReqDto();
        updateDto.setId(logId);
        updateDto.setSgStatus(sourceOrderExecuteResultVo.getSourceOrderResultRespDto().getSgStatus());
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderExecuteResultVo.getSourceOrderResultRespDto().getSgStatus())) {
            updateDto.setSgSourceResult(stringBuilder.toString());
        }
        this.sourceLogService.modifySourceLog(updateDto);
    }
}

