/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.FreightCostReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.FreightCostRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IFreightCostService;
import com.dtyunxi.cube.center.source.dao.das.FreightCostDas;
import com.dtyunxi.cube.center.source.dao.eo.FreightCostEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FreightCostServiceImpl
implements IFreightCostService {
    @Resource
    private FreightCostDas freightCostDas;

    @Override
    public Long addFreightCost(FreightCostReqDto addReqDto) {
        this.checkParam(addReqDto);
        FreightCostEo eo = (FreightCostEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.freightCostDas.filter().eq((Object)"logistics_warehouse_code", (Object)addReqDto.getLogisticsWarehouseCode())).eq((Object)"route_load_code", (Object)addReqDto.getRouteLoadCode())).one();
        if (eo != null) {
            throw new BizException("\u8def\u7ebf\u4e0d\u552f\u4e00");
        }
        FreightCostEo freightCostEo = new FreightCostEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)freightCostEo);
        freightCostEo.setRouteCode(freightCostEo.getLogisticsWarehouseCode() + freightCostEo.getRouteLoadCode());
        this.freightCostDas.insert((BaseEo)freightCostEo);
        return freightCostEo.getId();
    }

    @Override
    public void modifyFreightCost(FreightCostReqDto modifyReqDto) {
        FreightCostEo freightCostEo = new FreightCostEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)freightCostEo);
        this.freightCostDas.updateSelective((BaseEo)freightCostEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeFreightCost(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.freightCostDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public FreightCostRespDto queryById(Long id) {
        FreightCostEo freightCostEo = (FreightCostEo)this.freightCostDas.selectByPrimaryKey(id);
        if (freightCostEo == null) {
            return null;
        }
        FreightCostRespDto freightCostRespDto = new FreightCostRespDto();
        DtoHelper.eo2Dto((BaseEo)freightCostEo, (BaseVo)freightCostRespDto);
        return freightCostRespDto;
    }

    @Override
    public PageInfo<FreightCostRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        FreightCostReqDto freightCostReqDto = (FreightCostReqDto)JSON.parseObject((String)filter, FreightCostReqDto.class);
        FreightCostEo freightCostEo = this.queryWrapper(freightCostReqDto);
        PageInfo eoPageInfo = this.freightCostDas.selectPage((BaseEo)freightCostEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, FreightCostRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<FreightCostRespDto> queryListByWarehouseCodesAndRegionCode(List<String> warehouseCodes, String provinceCode, String cityCode, String areaCode) {
        ExtQueryChainWrapper children0 = (ExtQueryChainWrapper)this.freightCostDas.filter().in((Object)"logistics_warehouse_code", warehouseCodes);
        ExtQueryChainWrapper children1 = Optional.ofNullable(provinceCode).map(code -> (ExtQueryChainWrapper)children0.eq((Object)"province_code", (Object)provinceCode)).orElse(children0);
        ExtQueryChainWrapper children2 = Optional.ofNullable(provinceCode).map(code -> (ExtQueryChainWrapper)children0.eq((Object)"city_code", (Object)cityCode)).orElse(children1);
        ExtQueryChainWrapper children3 = Optional.ofNullable(provinceCode).map(code -> (ExtQueryChainWrapper)children0.eq((Object)"area_code", (Object)areaCode)).orElse(children2);
        List resultList = children3.list(Integer.valueOf(10000));
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            ArrayList<FreightCostRespDto> respDtoList = new ArrayList<FreightCostRespDto>();
            CubeBeanUtils.copyCollection(respDtoList, (Collection)resultList, FreightCostRespDto.class);
            return respDtoList;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<FreightCostReqDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List<FreightCostEo> eoList = saveList.stream().map(i -> {
            FreightCostEo eo = new FreightCostEo();
            DtoHelper.dto2Eo((BaseVo)i, (BaseEo)eo);
            eo.setCreatePerson(i.getOperator());
            eo.setUpdatePerson(i.getOperator());
            return eo;
        }).collect(Collectors.toList());
        List list = this.freightCostDas.queryListByCondition(eoList);
        ArrayList insertList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map map = list.stream().collect(Collectors.toMap(FreightCostEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
            eoList.forEach(i -> {
                String uniqueKey = i.getUniqueKey();
                if (map.containsKey(uniqueKey)) {
                    FreightCostEo freightCostEo = (FreightCostEo)map.get(uniqueKey);
                    freightCostEo.setVolumeUnitPrice(i.getVolumeUnitPrice());
                    freightCostEo.setLogisticsMerchantName(i.getLogisticsMerchantName());
                    freightCostEo.setRouteName(i.getRouteName());
                    freightCostEo.setProvinceCode(i.getProvinceCode());
                    freightCostEo.setCityCode(i.getCityCode());
                    freightCostEo.setAreaCode(i.getAreaCode());
                    updateList.add(freightCostEo);
                } else {
                    insertList.add(i);
                }
            });
        } else {
            insertList.addAll(eoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            insertList.forEach(i -> i.setRouteCode(i.getLogisticsWarehouseCode() + i.getRouteLoadCode()));
            this.freightCostDas.insertBatch((List)insertList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            updateList.forEach(i -> this.freightCostDas.updateSelective((BaseEo)i));
        }
    }

    @Override
    public Integer queryByCount(String filter) {
        FreightCostReqDto freightCostReqDto = (FreightCostReqDto)JSON.parseObject((String)filter, FreightCostReqDto.class);
        FreightCostEo freightCostEo = this.queryWrapper(freightCostReqDto);
        return this.freightCostDas.count((BaseEo)freightCostEo);
    }

    private void checkParam(FreightCostReqDto addReqDto) {
        SourceAssert.notBlank((String)addReqDto.getLogisticsMerchantCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7269\u6d41\u5546\u7f16\u7801"});
        SourceAssert.notBlank((String)addReqDto.getLogisticsWarehouseCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7269\u7406\u4ed3\u7f16\u7801"});
        SourceAssert.notBlank((String)addReqDto.getRouteLoadCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u6536\u8d27\u5730\u533a\u4ee3\u7801"});
        SourceAssert.notBlank((String)addReqDto.getProvinceCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7701\u7f16\u7801"});
        SourceAssert.notBlank((String)addReqDto.getCityCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5e02\u7f16\u7801"});
        if (addReqDto.getVolumeUnitPrice() == null || addReqDto.getVolumeUnitPrice().compareTo(BigDecimal.ZERO) == -1) {
            throw new BizException("\u4f53\u79ef\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e\u96f6");
        }
    }

    private FreightCostEo queryWrapper(FreightCostReqDto reqDto) {
        FreightCostEo freightCostEo = new FreightCostEo();
        ArrayList sqlFilters = Lists.newArrayList();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)freightCostEo);
        if (reqDto != null && StringUtils.isNotEmpty((String)reqDto.getRouteName())) {
            freightCostEo.setRouteName(null);
            sqlFilters.add(SqlFilter.like((String)"route_name", (Object)("%" + reqDto.getRouteName() + "%")));
        }
        freightCostEo.setSqlFilters((List)sqlFilters);
        freightCostEo.setOrderByDesc("create_time");
        return freightCostEo;
    }
}

