/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.track.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.track.api.dto.request.PcpOpenapiLogReqDto;
import com.dtyunxi.cube.center.track.api.dto.request.PcpSystemApiLogReqDto;
import com.dtyunxi.cube.center.track.api.dto.request.TransactionRetryLogReqDto;
import com.dtyunxi.cube.center.track.api.dto.response.PcpOpenapiLogRespDto;
import com.dtyunxi.cube.center.track.api.dto.response.PcpOpenapiRespDto;
import com.dtyunxi.cube.center.track.api.dto.response.PcpSystemApiLogRespDto;
import com.dtyunxi.cube.center.track.api.dto.response.TransactionNodeRespDto;
import com.dtyunxi.cube.center.track.api.dto.response.TransactionRetryLogRespDto;
import com.dtyunxi.cube.center.track.biz.service.IPcpOpenapiLogService;
import com.dtyunxi.cube.center.track.biz.service.ITransactionRetryLogService;
import com.dtyunxi.cube.center.track.dao.das.PcpOpenapiLogDas;
import com.dtyunxi.cube.center.track.dao.eo.PcpOpenapiLogEo;
import com.dtyunxi.cube.center.track.dao.vo.PcpSystemApiLogVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.constant.TransactionRetryLogRetryTypeEnum;
import com.dtyunxi.cube.component.track.commons.constant.TransactionRetryLogStatusEnum;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PcpOpenapiLogServiceImpl
implements IPcpOpenapiLogService {
    @Resource
    private PcpOpenapiLogDas pcpOpenapiLogDas;
    @Resource
    private ITransactionRetryLogService transactionRetryLogService;

    @Override
    public Long addPcpOpenapiLog(PcpOpenapiLogReqDto addReqDto) {
        PcpOpenapiLogEo pcpOpenapiLogEo = new PcpOpenapiLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)pcpOpenapiLogEo);
        this.pcpOpenapiLogDas.insert((BaseEo)pcpOpenapiLogEo);
        return pcpOpenapiLogEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Long addPcpOpenapiLogRetryLog(PcpOpenapiLogRespDto openapiLogRespDto, TransactionNodeRespDto transactionNodeRespDto) {
        TransactionRetryLogReqDto retryLogReqDto = this.buildTransactionRetryLogReqDtoByOpenapiLogDto(openapiLogRespDto, transactionNodeRespDto);
        List<TransactionRetryLogRespDto> transactionRetryLogRespDtos = this.transactionRetryLogService.queryByNodeRecordId(retryLogReqDto.getNodeRecordId());
        if (this.checkRepeatInsertRetryLog(transactionRetryLogRespDtos, null, retryLogReqDto.getNodeRecordId())) {
            throw new BizException("-1", "\u91cd\u590d\u63d2\u5165\uff0c\u5df2\u7ecf\u5b58\u5728\u91cd\u8bd5\u4e2d\u7684\u8bb0\u5f55");
        }
        Long retryLogId = this.transactionRetryLogService.addTransactionRetryLog(retryLogReqDto);
        transactionRetryLogRespDtos = this.transactionRetryLogService.queryByNodeRecordId(retryLogReqDto.getNodeRecordId());
        if (this.checkRepeatInsertRetryLog(transactionRetryLogRespDtos, retryLogId, retryLogReqDto.getNodeRecordId())) {
            throw new BizException("-1", "\u91cd\u590d\u63d2\u5165\uff0c\u5df2\u7ecf\u5b58\u5728\u91cd\u8bd5\u4e2d\u7684\u8bb0\u5f55");
        }
        return retryLogId;
    }

    private boolean checkRepeatInsertRetryLog(List<TransactionRetryLogRespDto> transactionRetryLogRespDtos, Long retryLogId, Long nodeRecordId) {
        if (CollectionUtils.isEmpty(transactionRetryLogRespDtos)) {
            return false;
        }
        return transactionRetryLogRespDtos.stream().filter(retryLogRespDto -> !Objects.equals(retryLogRespDto.getId(), retryLogId) && Objects.equals(retryLogRespDto.getNodeRecordId(), nodeRecordId) && !Objects.equals(retryLogRespDto.getRetryStatus(), TransactionRetryLogStatusEnum.RT_FINNISH.getCode())).count() >= 1L;
    }

    private TransactionRetryLogReqDto buildTransactionRetryLogReqDtoByOpenapiLogDto(PcpOpenapiLogRespDto pcpOpenapiLogRespDto, TransactionNodeRespDto transactionNodeRespDto) {
        TransactionRetryLogReqDto transactionRetryLogReqDto = new TransactionRetryLogReqDto();
        CubeBeanUtils.copyProperties((Object)transactionRetryLogReqDto, (Object)pcpOpenapiLogRespDto, (String[])new String[0]);
        CubeBeanUtils.copyProperties((Object)transactionRetryLogReqDto, (Object)transactionNodeRespDto, (String[])new String[0]);
        transactionRetryLogReqDto.setId(null);
        transactionRetryLogReqDto.setRetryApplyTime(new Date());
        transactionRetryLogReqDto.setRetryType(Integer.valueOf(TransactionRetryLogRetryTypeEnum.R_NODE.getCode()));
        transactionRetryLogReqDto.setRetryStatus(Integer.valueOf(TransactionRetryLogStatusEnum.RT_APPLY.getCode()));
        return transactionRetryLogReqDto;
    }

    @Override
    public void modifyPcpOpenapiLog(PcpOpenapiLogReqDto modifyReqDto) {
        PcpOpenapiLogEo pcpOpenapiLogEo = new PcpOpenapiLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)pcpOpenapiLogEo);
        if (ObjectUtil.isNotEmpty((Object)modifyReqDto.getExtFields())) {
            pcpOpenapiLogEo.setExtension(JSON.toJSONString((Object)modifyReqDto.getExtFields()));
        }
        this.pcpOpenapiLogDas.updateSelective((BaseEo)pcpOpenapiLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePcpOpenapiLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.pcpOpenapiLogDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PcpOpenapiLogRespDto queryById(Long id) {
        PcpOpenapiLogEo pcpOpenapiLogEo = (PcpOpenapiLogEo)this.pcpOpenapiLogDas.selectByPrimaryKey(id);
        PcpOpenapiLogRespDto pcpOpenapiLogRespDto = new PcpOpenapiLogRespDto();
        DtoHelper.eo2Dto((BaseEo)pcpOpenapiLogEo, (BaseVo)pcpOpenapiLogRespDto);
        return pcpOpenapiLogRespDto;
    }

    @Override
    public PageInfo<PcpOpenapiLogRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PcpOpenapiLogReqDto pcpOpenapiLogReqDto = (PcpOpenapiLogReqDto)JSON.parseObject((String)filter, PcpOpenapiLogReqDto.class);
        PcpOpenapiLogEo pcpOpenapiLogEo = new PcpOpenapiLogEo();
        DtoHelper.dto2Eo((BaseVo)pcpOpenapiLogReqDto, (BaseEo)pcpOpenapiLogEo);
        PageInfo eoPageInfo = this.pcpOpenapiLogDas.selectPage((BaseEo)pcpOpenapiLogEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PcpOpenapiLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<PcpSystemApiLogRespDto> queryPcpSystemApiLogPage(String filter, Integer pageNum, Integer pageSize) {
        PcpSystemApiLogReqDto pcpSystemApiLogReqDto = (PcpSystemApiLogReqDto)JSON.parseObject((String)filter, PcpSystemApiLogReqDto.class);
        PcpSystemApiLogVo pcpSystemApiLogVo = new PcpSystemApiLogVo();
        DtoHelper.dto2Eo((BaseVo)pcpSystemApiLogReqDto, (BaseEo)pcpSystemApiLogVo);
        if (pcpSystemApiLogReqDto.getApiAccessTimeStart() != null && pcpSystemApiLogReqDto.getApiAccessTimeEnd() != null) {
            pcpSystemApiLogVo.setApiAccessTimeStart(DateUtil.getDateFormat((Date)pcpSystemApiLogReqDto.getApiAccessTimeStart(), (String)"yyyy-MM-dd HH:mm:ss"));
            pcpSystemApiLogVo.setApiAccessTimeEnd(DateUtil.getDateFormat((Date)pcpSystemApiLogReqDto.getApiAccessTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List voList = this.pcpOpenapiLogDas.queryPcpSystemApiLogPage(pcpSystemApiLogVo);
        if (CollectionUtils.isEmpty((Collection)voList)) {
            return new PageInfo(new ArrayList());
        }
        List pcpSystemApiLogRespDtoList = voList.stream().map(vo -> {
            PcpSystemApiLogRespDto pcpSystemApiLogRespDto = new PcpSystemApiLogRespDto();
            PcpOpenapiRespDto pcpOpenapiRespDto = new PcpOpenapiRespDto();
            pcpSystemApiLogRespDto.setPcpOpenapiRespDto(pcpOpenapiRespDto);
            CubeBeanUtils.copyProperties((Object)pcpSystemApiLogRespDto, (Object)vo, (String[])new String[0]);
            CubeBeanUtils.copyProperties((Object)pcpOpenapiRespDto, (Object)vo, (String[])new String[0]);
            return pcpSystemApiLogRespDto;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(voList);
        pageInfo.setList(pcpSystemApiLogRespDtoList);
        return pageInfo;
    }

    @Override
    public PcpSystemApiLogRespDto queryPcpSystemApiLogById(Long id) {
        if (id == null) {
            return null;
        }
        PcpSystemApiLogVo pcpSystemApiLogVo = new PcpSystemApiLogVo();
        pcpSystemApiLogVo.setId(id);
        List voList = this.pcpOpenapiLogDas.queryPcpSystemApiLogPage(pcpSystemApiLogVo);
        PcpSystemApiLogRespDto result = null;
        if (voList.size() > 1) {
            throw new BizException("-1", "\u67e5\u8be2\u7ed3\u679c\u5927\u5c0f\u4e0d\u4e3a\u4e00");
        }
        if (voList.size() == 1) {
            result = new PcpSystemApiLogRespDto();
            PcpOpenapiRespDto pcpOpenapiRespDto = new PcpOpenapiRespDto();
            result.setPcpOpenapiRespDto(pcpOpenapiRespDto);
            CubeBeanUtils.copyProperties((Object)result, voList.get(0), (String[])new String[0]);
            CubeBeanUtils.copyProperties((Object)pcpOpenapiRespDto, voList.get(0), (String[])new String[0]);
        }
        return result;
    }
}

