package com.dtyunxi.finance.api.query;

import com.dtyunxi.finance.api.dto.request.ApportionmentConfigExtReqDto;
import com.dtyunxi.finance.api.dto.request.ApportionmentConfigReqDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentConfigExtRespDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentConfigRespDto;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 分摊基础配置表服务接口
 *
 * @author jiaye
 * @since 2025-08-20
 */
@Api(tags = {"分摊基础配置表服务"})
@FeignClient(
        contextId = "com-dtyunxi-finance-api-query-IApportionmentConfigQueryApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/apportionment",
        url = "${com.dtyunxi.finance.api:}"
)
public interface IApportionmentConfigQueryApi {

    /**
     * 根据id查询分摊基础配置表
     *
     * @param id 分摊基础配置表id
     * @return 分摊基础配置表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询分摊基础配置表", notes = "根据id查询分摊基础配置表")
    RestResponse<ApportionmentConfigRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 分摊基础配置表分页数据
     *
     * @param reqDto   分摊基础配置表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分摊基础配置表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "分摊基础配置表分页数据", notes = "根据查询条件查询分摊基础配置表数据")
    RestResponse<PageInfo<ApportionmentConfigRespDto>> queryByPage(@RequestBody ApportionmentConfigExtReqDto reqDto,
                                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping("/getByCostModuleCodeList")
    @ApiOperation(value = "根据费用模块编码获取分摊基础配置", notes = "根据费用模块编码获取分摊基础配置")
    RestResponse<List<ApportionmentConfigExtRespDto>> queryByCostModuleCodeList(@RequestBody List<String> costModuleCodeList);

    @PostMapping("/getByParams")
    @ApiOperation(value = "根据参数获取分摊基础配置", notes = "根据参数获取分摊基础配置")
    RestResponse<ApportionmentConfigExtRespDto> queryByParams(@RequestBody ApportionmentConfigReqDto reqDto);

}
