package com.dtyunxi.finance.api.exception;

import java.util.HashMap;
import java.util.Map;

public enum FinanceExceptionEnum {
    REPEAT_FEE_CONFIG_ADD("10000", "重复的费用归属设置"),
    RECORD_NOT_EXIST("10001", "记录不存在"),
    SORTING_CONTRACT_END_TIME_LOSE_EFFECT("10002", "结束时间已过期"),
    INVALID_DATE("10003", "非法开始时间"),
    OUT_WAREHOUSE_RECORD_NOT_EXIST("10004", "调出逻辑仓记录不存在"),
    IN_WAREHOUSE_RECORD_NOT_EXIST("10005", "调入逻辑仓记录不存在"),
    FEE_ATTR_CONFIG_WAREHOUSE_RECORD_NOT_EXIST("10006", "费用归属组织记录不存在"),
    IN_OUT_SAME("10007", "调入仓和调出仓是同一个"),
    EFFECTIVE_TIME_REPEATABLE("4061","保存失败，同物流商+承运方式+保险公司下，有效时间范围重叠"),
    ;


    private String code;
    private String message;

    FinanceExceptionEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static final Map<String, String> EXCEPTION_MAP = new HashMap<>();

    static {
        FinanceExceptionEnum[] values = FinanceExceptionEnum.values();
        for (FinanceExceptionEnum value : values) {
            String type = value.code;
            String desc = value.message;
            EXCEPTION_MAP.put(type, desc);
        }
    }
}
