package com.dtyunxi.finance.api;

import com.dtyunxi.finance.api.dto.request.CloseAccSettingEnableReqDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.CloseAccSettingReqDto;
import com.dtyunxi.finance.api.dto.response.CloseAccSettingRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import javax.validation.Valid;

/**
* 财务关账设置服务接口
*
* @author mc
* @since 2022-11-02
*/
@Api(tags = {"财务关账设置服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-ICloseAccSettingApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/closeAcc",
    url = "${com.dtyunxi.finance.api:}"
)
public interface ICloseAccSettingApi {

    /**
    * 新增财务关账设置
    *
    * @param addReqDto 财务关账设置请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增财务关账设置", notes = "新增财务关账设置")
    RestResponse<Long> addCloseAccSetting(@RequestBody CloseAccSettingReqDto addReqDto);

    /**
    * 修改财务关账设置
    *
    * @param modifyReqDto 财务关账设置请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改财务关账设置", notes = "修改财务关账设置")
    RestResponse<Void> modifyCloseAccSetting(@RequestBody CloseAccSettingReqDto modifyReqDto);

    /**
     * 修改财务关账设置
     *
     * @param enableReqDto 财务关账设置请求对象
     * @return 处理结果
     */
    @PostMapping("/enable")
    @ApiOperation(value = "财务关账开关设置", notes = "财务关账开关设置")
    RestResponse<Void> enable(@Valid @RequestBody CloseAccSettingEnableReqDto enableReqDto);


    /**
    * 删除财务关账设置
    *
    * @param ids        财务关账设置删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除财务关账设置", notes = "删除财务关账设置")
    RestResponse<Void> removeCloseAccSetting(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
