package com.dtyunxi.finance.api.exception;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum ChargeModeEnum {
    VOLUME(1,"按件/体积", "体积"),
    TRANSPORT(2,"按体积计费", "体积"),
    WEIGHT(3,"按重量计费", "重量"),
    MINIMUM(4,"按最低收费", "体积"),
    FIXED_PRICE(5,"定价导入", "定价"),
    NO_CHARGE(6,"不计费", "无"),
    SELF_LIFTING(7,"自提", "无"),
    VOLUME_TWO(12,"按件/体积2", "体积"),
    ;

    private Integer type;
    private String name;
    private String defaultUnitName;

    ChargeModeEnum(Integer type, String name, String defaultUnitName) {
        this.type = type;
        this.name = name;
        this.defaultUnitName = defaultUnitName;
    }

    public static final Map<Integer, ChargeModeEnum> CHARGE_MODE_TYPE_MAP = new HashMap<>();

    static {
        CHARGE_MODE_TYPE_MAP.put(VOLUME.getType(), VOLUME);
        CHARGE_MODE_TYPE_MAP.put(TRANSPORT.getType(), TRANSPORT);
        CHARGE_MODE_TYPE_MAP.put(WEIGHT.getType(), WEIGHT);
        CHARGE_MODE_TYPE_MAP.put(MINIMUM.getType(), MINIMUM);

        CHARGE_MODE_TYPE_MAP.put(FIXED_PRICE.getType(), FIXED_PRICE);
        CHARGE_MODE_TYPE_MAP.put(NO_CHARGE.getType(), NO_CHARGE);
        CHARGE_MODE_TYPE_MAP.put(SELF_LIFTING.getType(), SELF_LIFTING);
        CHARGE_MODE_TYPE_MAP.put(VOLUME_TWO.getType(), VOLUME_TWO);
    }

    public static ChargeModeEnum getChargeMode(Integer type) {
        ChargeModeEnum chargeModeEnum = CHARGE_MODE_TYPE_MAP.get(type);
        return chargeModeEnum;
    }
}
