package com.dtyunxi.finance.api.dto.request.logistic;

import com.dtyunxi.finance.api.dto.entity.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "LogisticRecordQueryReqDto", description = "油价联动配置Dto")
public class LogisticRecordQueryReqDto extends BasePageDto {

    @ApiModelProperty(name = "warehouseId", value = "仓库名称ID")
    private String warehouseId;

    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(name = "logisticId", value = "物流公司ID")
    private String logisticId;

    @ApiModelProperty(name = "logisticCompany", value = "物流公司")
    private String logisticCompany;

    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;

    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private String chargeMode;

    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;
    /**
     * 查询标识
     */
    @ApiModelProperty(name = "flag", value = "物流费用报表更新账单查询标识")
    private Integer flag;

    @ApiModelProperty(name = "validYear", value = "有效年份")
    private String validYear;
}
