package com.dtyunxi.finance.api.dto.request;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.finance.api.exception.SeasonTypeEnum;
import com.dtyunxi.finance.api.exception.StorageContractEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

/**
* 仓储费合同表Eo对象
*
* @author xuanxin
* @since 2022-07-18
*/
@ApiModel(value = "StorageContractReqDto", description = "仓储费合同表Eo对象")
public class StorageContractReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  合同名称
    */
    @ApiModelProperty(name = "contractName", value = "合同名称")
    private String contractName;

    @ApiModelProperty(name = "chargeMode", value = "计算方式 1按半数；2按面积；3按金额")
    private Integer chargeMode;


    /**
    *  是否作废;0:未作废;1:作废;
    */
    @ApiModelProperty(name = "isCancel", value = "是否作废;0:未作废;1:作废;")
    private Integer isCancel;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
    *  合同每月日均板数
    */
    @ApiModelProperty(name = "contractAverageSupport", value = "合同每月日均板数")
    private Integer contractAverageSupport;
    /**
     *  合同合作开始日期
     */
    @ApiModelProperty(name = "contractCooperativeStartTime", value = "合同合作开始日期")
    private Date contractCooperativeStartTime;
    /**
     *  合同合作结束日期
     */
    @ApiModelProperty(name = "contractCooperativeEndTime", value = "合同合作结束日期")
    private Date contractCooperativeEndTime;
    /**
    *  有效开始时间
    */
    @ApiModelProperty(name = "validStartTime", value = "有效开始时间")
    private Date validStartTime;
    /**
    *  有效结束时间
    */
    @ApiModelProperty(name = "validEndTime", value = "有效结束时间")
    private Date validEndTime;
    /**
     *
    *  组织id
    */
    @ApiModelProperty(name = "orgId", value = "组织id")
    private Long orgId;

    /**
     *  状态
     */
    @ApiModelProperty(name = "stateList",value = "订单状态")
    private List<StorageContractEnum> stateList;

    /**
     *  仓储合同详情请求
     */
    @ApiModelProperty(name = "storageContractDetailReqDto",value = "仓储合同详情表")
    private List<StorageContractDetailReqDto> storageContractDetailReqDtoList;

    /**
     *  仓储费用合同变更记录请求
     */
    @ApiModelProperty(name = "storageContractChangeRecordReqDto",value = "仓储费用合同变更记录表")
    private StorageContractChangeRecordReqDto storageContractChangeRecordReqDto;

    /**
     * 有效年份
     */
    @ApiModelProperty(name = "validYear", value = "有效年份")
    private String validYear;

    public Date getContractCooperativeStartTime() {
        return contractCooperativeStartTime;
    }

    public void setContractCooperativeStartTime(Date contractCooperativeStartTime) {
        this.contractCooperativeStartTime = contractCooperativeStartTime;
    }

    public Date getContractCooperativeEndTime() {
        return contractCooperativeEndTime;
    }

    public void setContractCooperativeEndTime(Date contractCooperativeEndTime) {
        this.contractCooperativeEndTime = contractCooperativeEndTime;
    }

    public Integer getChargeMode() {
        return chargeMode;
    }

    public void setChargeMode(Integer chargeMode) {
        this.chargeMode = chargeMode;
    }

    public String getValidYear() {
        return validYear;
    }

    public void setValidYear(String validYear) {
        this.validYear = validYear;
    }

    public StorageContractChangeRecordReqDto getStorageContractChangeRecordReqDto() {
        return storageContractChangeRecordReqDto;
    }

    public void setStorageContractChangeRecordReqDto(StorageContractChangeRecordReqDto storageContractChangeRecordReqDto) {
        this.storageContractChangeRecordReqDto = storageContractChangeRecordReqDto;
    }

    public List<StorageContractDetailReqDto> getStorageContractDetailReqDtoList() {
        return storageContractDetailReqDtoList;
    }

    public void setStorageContractDetailReqDtoList(List<StorageContractDetailReqDto> storageContractDetailReqDtoList) {
        this.storageContractDetailReqDtoList = storageContractDetailReqDtoList;
    }

    public List<StorageContractEnum> getStateList() {
        return stateList;
    }

    public void setStateList(List<StorageContractEnum> stateList) {
        this.stateList = stateList;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setContractName(String contractName){
    this.contractName = contractName;
    }
    public String getContractName(){
    return this.contractName;
    }
    public void setIsCancel(Integer isCancel){
    this.isCancel = isCancel;
    }
    public Integer getIsCancel(){
    return this.isCancel;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setContractAverageSupport(Integer contractAverageSupport){
    this.contractAverageSupport = contractAverageSupport;
    }
    public Integer getContractAverageSupport(){
    return this.contractAverageSupport;
    }
    public void setValidStartTime(Date validStartTime){
    this.validStartTime = validStartTime;
    }
    public Date getValidStartTime(){
    return this.validStartTime;
    }
    public void setValidEndTime(Date validEndTime){
    this.validEndTime = validEndTime;
    }
    public Date getValidEndTime(){
    return this.validEndTime;
    }
    public void setOrgId(Long orgId){
    this.orgId = orgId;
    }
    public Long getOrgId(){
    return this.orgId;
    }
}
