package com.dtyunxi.finance.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.StorageContractDetailReqDto;
import com.dtyunxi.finance.api.dto.response.StorageContractDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
 * 仓储费用关联明细表服务接口
 *
 * @author xuanxin
 * @since 2022-07-18
 */
@Api(tags = {"仓储费用关联明细表服务"})
@FeignClient(
        contextId = "com-dtyunxi-finance-api-IStorageContractDetailApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/storageContractDetail",
        url = "${com.dtyunxi.finance.api:}"
)
public interface IStorageContractDetailApi {

    /**
     * 新增仓储费用关联明细表
     *
     * @param addReqDto 仓储费用关联明细表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增仓储费用关联明细表", notes = "新增仓储费用关联明细表")
    RestResponse<Long> addStorageContractDetail(@RequestBody StorageContractDetailReqDto addReqDto);

    /**
     * 修改仓储费用关联明细表
     *
     * @param modifyReqDto 仓储费用关联明细表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改仓储费用关联明细表", notes = "修改仓储费用关联明细表")
    RestResponse<Void> modifyStorageContractDetail(@RequestBody StorageContractDetailReqDto modifyReqDto);

    /**
     * 删除仓储费用关联明细表
     *
     * @param ids        仓储费用关联明细表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除仓储费用关联明细表", notes = "删除仓储费用关联明细表")
    RestResponse<Void> removeStorageContractDetail(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
