/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.ApportionmentConfigExtReqDto;
import com.dtyunxi.finance.api.dto.request.ApportionmentConfigReqDto;
import com.dtyunxi.finance.api.dto.request.ApportionmentConfigSaveReqDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentConfigExtRespDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentConfigRespDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrderBizTypeRespDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrganizationRespDto;
import com.dtyunxi.finance.biz.service.IApportionmentConfigService;
import com.dtyunxi.finance.biz.service.IApportionmentOrderBizTypeService;
import com.dtyunxi.finance.biz.service.IApportionmentOrganizationService;
import com.dtyunxi.finance.biz.util.AssertUtil;
import com.dtyunxi.finance.biz.util.CodeGenerateUtil;
import com.dtyunxi.finance.dao.das.ApportionmentConfigDas;
import com.dtyunxi.finance.dao.eo.ApportionmentConfigEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ApportionmentConfigServiceImpl
implements IApportionmentConfigService {
    private static final Logger log = LoggerFactory.getLogger(ApportionmentConfigServiceImpl.class);
    @Resource
    private ApportionmentConfigDas configDas;
    @Resource
    private IApportionmentOrderBizTypeService orderBizTypeService;
    @Resource
    private IApportionmentOrganizationService organizationService;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;

    @Override
    public void saveConfig(ApportionmentConfigSaveReqDto addReqDto) {
        log.info("\u4fdd\u5b58\u5206\u644a\u57fa\u7840\u914d\u7f6e\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)addReqDto));
        this.checkParams(addReqDto);
        Long id = addReqDto.getId();
        List organizationList = addReqDto.getOrganizationList();
        List orderBizTypeList = addReqDto.getOrderBizTypeList();
        if (Objects.nonNull(id)) {
            ApportionmentConfigEo configEo = (ApportionmentConfigEo)this.configDas.selectByPrimaryKey(id);
            AssertUtil.isFalse(Objects.isNull(configEo), "\u5206\u644a\u57fa\u7840\u914d\u7f6e\u4e0d\u5b58\u5728");
            String ruleCode = configEo.getRuleCode();
            addReqDto.setRuleCode(ruleCode);
            ApportionmentConfigEo updateEo = new ApportionmentConfigEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)updateEo);
            this.configDas.updateSelective((BaseEo)updateEo);
            this.orderBizTypeService.batchCreate(ruleCode, id, orderBizTypeList);
            this.organizationService.batchCreate(ruleCode, id, organizationList);
            return;
        }
        String ruleCode = this.codeGenerateUtil.generateNo("GFZ", 6);
        addReqDto.setRuleCode(ruleCode);
        ApportionmentConfigEo configEo = new ApportionmentConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)configEo);
        this.configDas.insert((BaseEo)configEo);
        id = configEo.getId();
        this.orderBizTypeService.batchCreate(ruleCode, id, orderBizTypeList);
        this.organizationService.batchCreate(ruleCode, id, organizationList);
    }

    private void checkParams(ApportionmentConfigSaveReqDto addReqDto) {
        List organizationList = addReqDto.getOrganizationList();
        List orderBizTypeList = addReqDto.getOrderBizTypeList();
        AssertUtil.isFalse(CollUtil.isEmpty((Collection)organizationList), "\u8bf7\u9009\u62e9\u7ec4\u7ec7\u5173\u7cfb");
        AssertUtil.isFalse(CollUtil.isEmpty((Collection)orderBizTypeList), "\u8bf7\u9009\u62e9\u5355\u636e\u4e1a\u52a1\u7c7b\u578b");
        Long id = addReqDto.getId();
        String costModuleCode = addReqDto.getCostModuleCode();
        List configEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.configDas.filter().ne(Objects.nonNull(id), (Object)"id", (Object)id)).eq((Object)"cost_module_code", (Object)costModuleCode)).list(Integer.valueOf(1));
        AssertUtil.isFalse(CollUtil.isNotEmpty((Collection)configEos), "\u8d39\u7528\u6a21\u5757\u5df2\u5b58\u5728");
    }

    @Override
    public List<ApportionmentConfigExtRespDto> queryByCostModuleCodeList(List<String> costModuleCodeList) {
        List configEos = ((ExtQueryChainWrapper)this.configDas.filter().in((Object)"cost_module_code", costModuleCodeList)).list();
        if (CollectionUtils.isEmpty((Collection)configEos)) {
            return null;
        }
        return configEos.stream().map(this::getByEo).collect(Collectors.toList());
    }

    @Override
    public ApportionmentConfigExtRespDto queryByCostModuleCode(String costModuleCode) {
        List configEos = ((ExtQueryChainWrapper)this.configDas.filter().eq((Object)"cost_module_code", (Object)costModuleCode)).list(Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)configEos)) {
            return null;
        }
        ApportionmentConfigEo configEo = (ApportionmentConfigEo)configEos.get(0);
        return this.getByEo(configEo);
    }

    @Override
    public ApportionmentConfigExtRespDto queryByParams(ApportionmentConfigReqDto reqDto) {
        ApportionmentConfigEo eo = new ApportionmentConfigEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        List configEos = this.configDas.select((BaseEo)eo);
        if (CollectionUtils.isEmpty((Collection)configEos)) {
            return null;
        }
        ApportionmentConfigEo configEo = (ApportionmentConfigEo)configEos.get(0);
        return this.getByEo(configEo);
    }

    private ApportionmentConfigExtRespDto getByEo(ApportionmentConfigEo configEo) {
        if (Objects.isNull(configEo)) {
            return null;
        }
        String ruleCode = configEo.getRuleCode();
        ApportionmentConfigExtRespDto configRespDto = new ApportionmentConfigExtRespDto();
        DtoHelper.eo2Dto((BaseEo)configEo, (BaseVo)configRespDto);
        List<ApportionmentOrganizationRespDto> organizationList = this.organizationService.getByRuleCode(ruleCode);
        List<ApportionmentOrderBizTypeRespDto> orderBizTypeList = this.orderBizTypeService.getByRuleCode(ruleCode);
        configRespDto.setOrganizationList(organizationList);
        configRespDto.setOrderBizTypeList(orderBizTypeList);
        return configRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeApportionmentConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.configDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ApportionmentConfigRespDto queryById(Long id) {
        ApportionmentConfigEo apportionmentConfigEo = (ApportionmentConfigEo)this.configDas.selectByPrimaryKey(id);
        ApportionmentConfigRespDto apportionmentConfigRespDto = new ApportionmentConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)apportionmentConfigEo, (BaseVo)apportionmentConfigRespDto);
        return apportionmentConfigRespDto;
    }

    @Override
    public PageInfo<ApportionmentConfigRespDto> queryByPage(ApportionmentConfigExtReqDto reqDto, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo eoPageInfo = new PageInfo(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.configDas.filter().in(CollUtil.isNotEmpty((Collection)reqDto.getCostModuleCodeList()), (Object)"cost_module_code", (Collection)reqDto.getCostModuleCodeList())).like(StrUtil.isNotBlank((CharSequence)reqDto.getRuleCode()), (Object)"rule_code", (Object)reqDto.getRuleCode())).like(StrUtil.isNotBlank((CharSequence)reqDto.getRuleName()), (Object)"rule_name", (Object)reqDto.getRuleName())).eq(Objects.nonNull(reqDto.getIsShareholdingApportionment()), (Object)"is_shareholding_apportionment", (Object)reqDto.getIsShareholdingApportionment())).orderByDesc((Object)"create_time")).list());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), (Collection)list, ApportionmentConfigRespDto.class);
        dtoPageInfo.setList((List)list);
        return dtoPageInfo;
    }
}

