/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.finance.api.dto.request.FeeAttributionConfigDetailQueryReqDto;
import com.dtyunxi.finance.api.dto.request.FeeAttributionConfigListQueryReqDto;
import com.dtyunxi.finance.api.dto.request.SubmitFeeAttributionConfigAddReqDto;
import com.dtyunxi.finance.api.dto.request.SubmitFeeAttributionConfigEditReqDto;
import com.dtyunxi.finance.api.dto.response.FeeAttributionConfigRespDto;
import com.dtyunxi.finance.api.exception.FinanceException;
import com.dtyunxi.finance.api.exception.FinanceExceptionEnum;
import com.dtyunxi.finance.biz.service.FeeAttributionConfigService;
import com.dtyunxi.finance.dao.das.FeeAttributionConfigDas;
import com.dtyunxi.finance.dao.eo.FeeAttributionConfigEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class FeeAttributionConfigServiceServiceImpl
implements FeeAttributionConfigService {
    private static final Logger log = LoggerFactory.getLogger(FeeAttributionConfigServiceServiceImpl.class);
    @Autowired
    private FeeAttributionConfigDas feeAttributionConfigDas;
    FeeAttributionConfigService feeAttributionConfigService;

    @Autowired
    public FeeAttributionConfigServiceServiceImpl(@Lazy FeeAttributionConfigService feeAttributionConfigService) {
        this.feeAttributionConfigService = feeAttributionConfigService;
    }

    @Override
    @Transactional
    public RestResponse<Object> addFeeAttributionConfig(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitFeeAttributionConfigAddReqDto submitFeeAttributionConfigAddReqDto) {
        String inWarehouseCode = submitFeeAttributionConfigAddReqDto.getInWarehouseCode();
        String outWarehouseCode = submitFeeAttributionConfigAddReqDto.getOutWarehouseCode();
        FeeAttributionConfigEo eo = (FeeAttributionConfigEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.feeAttributionConfigDas.filter().eq((Object)"out_warehouse_code", (Object)outWarehouseCode)).eq((Object)"in_warehouse_code", (Object)inWarehouseCode)).last("limit 1")).one();
        FeeAttributionConfigEo feeAttributionConfigEo = new FeeAttributionConfigEo();
        DtoHelper.dto2Eo((BaseVo)submitFeeAttributionConfigAddReqDto, (BaseEo)feeAttributionConfigEo);
        feeAttributionConfigEo.setCostBelongOrgCode(submitFeeAttributionConfigAddReqDto.getCostBelongOrgCode());
        if (eo == null) {
            this.feeAttributionConfigDas.insert((BaseEo)feeAttributionConfigEo);
        } else {
            feeAttributionConfigEo.setId(eo.getId());
            this.feeAttributionConfigDas.updateSelective((BaseEo)feeAttributionConfigEo);
        }
        return new RestResponse();
    }

    @Override
    @Transactional
    public RestResponse<Object> editFeeAttributionConfig(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitFeeAttributionConfigEditReqDto submitFeeAttributionConfigAddReqDto) {
        Long id = submitFeeAttributionConfigAddReqDto.getId();
        FeeAttributionConfigEo example = new FeeAttributionConfigEo(id);
        FeeAttributionConfigEo record = (FeeAttributionConfigEo)this.feeAttributionConfigDas.selectOne((BaseEo)example);
        if (Objects.isNull(record)) {
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.RECORD_NOT_EXIST);
        }
        submitFeeAttributionConfigAddReqDto.setOutWarehouseCodeOld(record.getOutWarehouseCode());
        submitFeeAttributionConfigAddReqDto.setInWarehouseCodeOld(record.getInWarehouseCode());
        this.validateWareHouseAndOrgForEdit(submitFeeAttributionConfigAddReqDto);
        FeeAttributionConfigEo feeAttributionConfigEo = new FeeAttributionConfigEo();
        DtoHelper.dto2Eo((BaseVo)submitFeeAttributionConfigAddReqDto, (BaseEo)feeAttributionConfigEo);
        this.feeAttributionConfigDas.updateSelective((BaseEo)feeAttributionConfigEo);
        return new RestResponse();
    }

    public void validateWareHouseAndOrgForAdd(@Valid @ApiParam(value="") @RequestBody(required=false) SubmitFeeAttributionConfigAddReqDto submitFeeAttributionConfigAddReqDto) {
        FeeAttributionConfigEo example;
        List history;
        String inWarehouseCode;
        String outWarehouseCode = submitFeeAttributionConfigAddReqDto.getOutWarehouseCode();
        if (outWarehouseCode.equals(inWarehouseCode = submitFeeAttributionConfigAddReqDto.getInWarehouseCode())) {
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.IN_OUT_SAME);
        }
        if (CollectionUtil.isNotEmpty((Collection)(history = this.feeAttributionConfigDas.selectList((BaseEo)(example = new FeeAttributionConfigEo(outWarehouseCode, inWarehouseCode)))))) {
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.REPEAT_FEE_CONFIG_ADD);
        }
    }

    public void validateWareHouseAndOrgForEdit(@Valid @ApiParam(value="") @RequestBody(required=false) SubmitFeeAttributionConfigEditReqDto submitFeeAttributionConfigAddReqDto) {
        FeeAttributionConfigEo example;
        List history;
        String inWarehouseCode;
        String outWarehouseCode = submitFeeAttributionConfigAddReqDto.getOutWarehouseCode();
        if (outWarehouseCode.equals(inWarehouseCode = submitFeeAttributionConfigAddReqDto.getInWarehouseCode())) {
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.IN_OUT_SAME);
        }
        String inWarehouseCodeOld = submitFeeAttributionConfigAddReqDto.getInWarehouseCodeOld();
        String outWarehouseCodeOld = submitFeeAttributionConfigAddReqDto.getOutWarehouseCodeOld();
        if (!(inWarehouseCode.equals(inWarehouseCodeOld) && outWarehouseCode.equals(outWarehouseCodeOld) || !CollectionUtil.isNotEmpty((Collection)(history = this.feeAttributionConfigDas.selectList((BaseEo)(example = new FeeAttributionConfigEo(outWarehouseCode, inWarehouseCode))))))) {
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.REPEAT_FEE_CONFIG_ADD);
        }
    }

    @Override
    public RestResponse<FeeAttributionConfigRespDto> detailFeeAttributionConfig(@ApiParam(value="") @Valid @RequestBody(required=false) FeeAttributionConfigDetailQueryReqDto feeAttributionConfigDetailQueryReqDto) {
        Long id = feeAttributionConfigDetailQueryReqDto.getId();
        String outWarehouseCode = feeAttributionConfigDetailQueryReqDto.getOutWarehouseCode();
        String inWarehouseCode = feeAttributionConfigDetailQueryReqDto.getInWarehouseCode();
        FeeAttributionConfigEo example = new FeeAttributionConfigEo();
        example.setId(id);
        example.setOutWarehouseCode(outWarehouseCode);
        example.setInWarehouseCode(inWarehouseCode);
        FeeAttributionConfigEo feeAttributionConfigEo = (FeeAttributionConfigEo)this.feeAttributionConfigDas.selectOne((BaseEo)example);
        FeeAttributionConfigRespDto feeAttributionConfigReqDto = new FeeAttributionConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)feeAttributionConfigEo, (BaseVo)feeAttributionConfigReqDto);
        return new RestResponse((Object)feeAttributionConfigReqDto);
    }

    @Override
    public RestResponse<PageInfo<FeeAttributionConfigRespDto>> getFeeAttributionConfigListPage(@ApiParam(value="") @Valid @RequestBody(required=false) FeeAttributionConfigListQueryReqDto feeAttributionConfigReqDto) {
        String inWarehouseName;
        String inOrgName;
        String outWarehouseName;
        String outOrgName;
        String inWarehouseCode;
        FeeAttributionConfigEo feeAttributionConfigEo = new FeeAttributionConfigEo();
        Integer pageNum = feeAttributionConfigReqDto.getPageNum();
        Integer pageSize = feeAttributionConfigReqDto.getPageSize();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        String outWarehouseCode = feeAttributionConfigReqDto.getOutWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)outWarehouseCode)) {
            sqlFilters.add(SqlFilter.eq((String)"out_warehouse_code", (Object)outWarehouseCode));
        }
        if (StringUtils.isNotBlank((CharSequence)(inWarehouseCode = feeAttributionConfigReqDto.getInWarehouseCode()))) {
            sqlFilters.add(SqlFilter.eq((String)"in_warehouse_code", (Object)inWarehouseCode));
        }
        if (StringUtils.isNotBlank((CharSequence)(outOrgName = feeAttributionConfigReqDto.getOutOrgName()))) {
            sqlFilters.add(SqlFilter.like((String)"out_org_name", (Object)("%" + outOrgName.concat("%"))));
        }
        if (StringUtils.isNotBlank((CharSequence)(outWarehouseName = feeAttributionConfigReqDto.getOutWarehouseName()))) {
            sqlFilters.add(SqlFilter.like((String)"out_warehouse_name", (Object)("%" + outWarehouseName.concat("%"))));
        }
        if (StringUtils.isNotBlank((CharSequence)(inOrgName = feeAttributionConfigReqDto.getInOrgName()))) {
            sqlFilters.add(SqlFilter.like((String)"in_org_name", (Object)("%" + inOrgName.concat("%"))));
        }
        if (StringUtils.isNotBlank((CharSequence)(inWarehouseName = feeAttributionConfigReqDto.getInWarehouseName()))) {
            sqlFilters.add(SqlFilter.like((String)"in_warehouse_name", (Object)("%" + inWarehouseName.concat("%"))));
        }
        feeAttributionConfigEo.setSqlFilters(sqlFilters);
        PageInfo eoPageInfo = this.feeAttributionConfigDas.selectPage((BaseEo)feeAttributionConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, FeeAttributionConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    @Transactional
    public RestResponse<FeeAttributionConfigRespDto> deleteFeeAttributionConfig(Long id) {
        this.feeAttributionConfigDas.logicDeleteById(id);
        return new RestResponse();
    }

    @Override
    @Transactional
    public RestResponse<Object> addBatchFeeAttributionConfig(List<SubmitFeeAttributionConfigAddReqDto> list) {
        for (SubmitFeeAttributionConfigAddReqDto submitFeeAttributionConfigAddReqDto : list) {
            log.info("\u8d39\u7528\u5f52\u5c5e\u5bfc\u5165---------------------userName:{}", (Object)submitFeeAttributionConfigAddReqDto.getCreatePerson());
            try {
                this.feeAttributionConfigService.addFeeAttributionConfig(submitFeeAttributionConfigAddReqDto);
            }
            catch (Exception e) {
                if (e instanceof FinanceException) {
                    log.info("\u8d39\u7528\u5f52\u5c5e\u5bfc\u5165---------------------exception:{}", (Object)((FinanceException)e).getErrorMsg());
                    continue;
                }
                log.info("\u8d39\u7528\u5f52\u5c5e\u5bfc\u5165---------------------exception:{}", (Object)e.getMessage());
            }
        }
        return new RestResponse();
    }
}

