/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.apiimpl;

import com.dtyunxi.finance.api.ILogisticApi;
import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.OilChangeReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.OilLinkReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.VolumeLadderDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilChangeRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkRespDto;
import com.dtyunxi.finance.biz.service.IAppointAreaService;
import com.dtyunxi.finance.biz.service.ILogisticRecordService;
import com.dtyunxi.finance.biz.service.IOilChangeService;
import com.dtyunxi.finance.biz.service.IOilLinkService;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="logisticApi")
public class LogisticApiImpl
implements ILogisticApi {
    Logger log = LoggerFactory.getLogger(LogisticApiImpl.class);
    @Resource
    private IOilChangeService oilChangeService;
    @Resource
    private IOilLinkService oilLinkService;
    @Resource
    private IAppointAreaService appointAreaService;
    @Resource
    private ILogisticRecordService logisticRecordService;

    public RestResponse<OilChangeRespDto> saveOilChange(OilChangeReqDto dto) {
        OilChangeRespDto respDto = this.oilChangeService.saveOilChange(dto);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<Long> removeOilChange(String id) {
        Long removeId = this.oilChangeService.removeOilChange(Long.valueOf(id));
        return new RestResponse((Object)removeId);
    }

    public RestResponse<OilLinkRespDto> saveOilLink(OilLinkReqDto dto) {
        OilLinkRespDto respDto = this.oilLinkService.saveOilLink(dto);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<Void> removeOilLink(Long id) {
        this.oilLinkService.removeOilLink(id);
        return new RestResponse();
    }

    public RestResponse<Long> saveLogisticRecord(LogisticRecordReqDto dto) {
        Long id = this.logisticRecordService.saveLogisticRecord(dto);
        return new RestResponse((Object)id);
    }

    public RestResponse<Long> removeLogisticRecord(String id) {
        Long removeId = this.logisticRecordService.removeLogisticRecord(Long.valueOf(id));
        return new RestResponse((Object)removeId);
    }

    public RestResponse<Long> copyLogisticRecord(String id) {
        Long copyId = this.logisticRecordService.copyLogisticRecord(Long.valueOf(id));
        return new RestResponse((Object)copyId);
    }

    public RestResponse<Long> abolishLogisticRecord(String id) {
        Long abolishId = this.logisticRecordService.abolishLogisticRecord(Long.valueOf(id));
        return new RestResponse((Object)abolishId);
    }

    public RestResponse<String> saveAppointArea(List<AppointAreaReqDto> reqDto) {
        this.appointAreaService.batchCreate(reqDto);
        return new RestResponse();
    }

    public RestResponse<Long> removeAppointArea(String id) {
        Long removeId = this.appointAreaService.removeAppointArea(Long.valueOf(id));
        return new RestResponse((Object)removeId);
    }

    public RestResponse<String> removeAllAppointArea(String templateId) {
        this.appointAreaService.removeAllAppointArea(templateId);
        return new RestResponse();
    }

    public RestResponse<Long> updateAppointAreaById(AppointAreaReqDto reqDto) {
        Long updateId = this.appointAreaService.updateAppointAreaById(reqDto);
        return new RestResponse((Object)updateId);
    }

    public RestResponse<Void> volumeLadderSave(VolumeLadderDto volumeLadderDto) {
        this.appointAreaService.volumeLadderSave(volumeLadderDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addAppointArea(AppointAreaReqDto reqDto) {
        return new RestResponse((Object)this.appointAreaService.addAppointArea(reqDto));
    }
}

