/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.exception;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum InterceptExceptionEnum {
    PRICE_CONTROL_INTERCEPT("8001", "ORDER_ITEM_PRICE_CONTROL", "\u8ba2\u5355\u5546\u54c1\u4ef7\u683c\u7ba1\u63a7"),
    PRICE_CONTROL_NOT_EXIST_INTERCEPT("8000", "PRICE_CONTROL_NOT_EXIST", "\u5546\u54c1\u672a\u8bbe\u7f6e\u7ba1\u63a7\u4ef7"),
    OTHER("-1", "OTHER", "\u5176\u4ed6");

    private String code;
    private String type;
    private String desc;
    public static final Map<String, InterceptExceptionEnum> CODE_LOOKUP;

    public String getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private InterceptExceptionEnum(String code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static InterceptExceptionEnum enumOf(String type) {
        for (InterceptExceptionEnum typeEnum : InterceptExceptionEnum.values()) {
            if (!typeEnum.getCode().equals(type)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", type, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    public static InterceptExceptionEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    static {
        CODE_LOOKUP = Arrays.stream(InterceptExceptionEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    }
}

