/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IInventorySharedApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.enums.GenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventorySharedItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventorySharedOperationLogReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventorySharedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventorySharedWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.InventorySharedItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.InventorySharedRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.InventorySharedWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IInventorySharedItemService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IInventorySharedOperationLogService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IInventorySharedService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IInventorySharedWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IRelVirtualWarehouseService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class InventorySharedApiImpl
implements IInventorySharedApi {
    private static final Logger log = LoggerFactory.getLogger(InventorySharedApiImpl.class);
    @Autowired
    IInventorySharedService inventorySharedService;
    @Autowired
    IInventorySharedItemService inventorySharedItemService;
    @Autowired
    IInventorySharedWarehouseService inventorySharedWarehouseService;
    @Autowired
    IInventorySharedOperationLogService inventorySharedOperationLogService;
    @Autowired
    IInventorySharedDomain inventorySharedDomain;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    IVirtualWarehouseDomain virtualWarehouseDomain;
    @Autowired
    IRelVirtualWarehouseService relVirtualWarehouseService;
    @Autowired
    ICalcInventoryService calcInventoryService;

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addInventoryShared(InventorySharedReqDto addReqDto) {
        this.checkParam(addReqDto);
        IGenerateCodeService strategy = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.SHARED_CODE.getCode());
        if (null == strategy) {
            throw new CsInventoryException("\u5171\u4eab\u7b56\u7565\u7f16\u7801\u89c4\u5219\u521d\u59cb\u5316\u5931\u8d25", new Object[0]);
        }
        addReqDto.setSharedCode(strategy.getCode());
        Long id = this.inventorySharedService.addInventoryShared(addReqDto);
        if ("part".equals(addReqDto.getSharedItemScope())) {
            for (InventorySharedItemReqDto itemReqDto : addReqDto.getSharedItemList()) {
                itemReqDto.setSharedCode(addReqDto.getSharedCode());
                itemReqDto.setSharedName(addReqDto.getSharedName());
                this.inventorySharedItemService.addInventorySharedItem(itemReqDto);
            }
        }
        for (InventorySharedWarehouseReqDto warehouseReqDto : addReqDto.getWarehouseList()) {
            warehouseReqDto.setSharedCode(addReqDto.getSharedCode());
            warehouseReqDto.setSharedName(addReqDto.getSharedName());
            this.inventorySharedWarehouseService.addInventorySharedWarehouse(warehouseReqDto);
        }
        InventorySharedOperationLogReqDto logReqDto = new InventorySharedOperationLogReqDto();
        logReqDto.setSharedCode(addReqDto.getSharedCode());
        logReqDto.setSharedName(addReqDto.getSharedName());
        logReqDto.setOperation("\u521b\u5efa");
        logReqDto.setOpetationContent("\u521b\u5efa\u89c4\u5219");
        this.inventorySharedOperationLogService.addInventorySharedOperationLog(logReqDto);
        return new RestResponse((Object)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modifyInventoryShared(InventorySharedReqDto modifyReqDto) {
        List warehouseIds;
        this.checkParam(modifyReqDto);
        InventorySharedRespDto inventorySharedRespDto = this.inventorySharedService.queryById(modifyReqDto.getId());
        List<InventorySharedItemRespDto> sharedItemList = new ArrayList();
        if ("part".equals(modifyReqDto.getSharedItemScope())) {
            sharedItemList = this.inventorySharedItemService.queryByPage("{sharedCode:'" + modifyReqDto.getSharedCode() + "'}", 1, 100000).getList();
        }
        List warehouseList = this.inventorySharedWarehouseService.queryByPage("{sharedCode:'" + modifyReqDto.getSharedCode() + "'}", 1, 10000).getList();
        this.inventorySharedService.modifyInventoryShared(modifyReqDto);
        List ids = sharedItemList.stream().map(InventorySharedItemRespDto::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(ids)) {
            String idStr = StringUtils.join(ids, (String)",");
            this.inventorySharedItemService.removeInventorySharedItem(idStr, 0L);
        }
        if ("part".equals(modifyReqDto.getSharedItemScope())) {
            for (InventorySharedItemReqDto itemReqDto : modifyReqDto.getSharedItemList()) {
                itemReqDto.setSharedCode(modifyReqDto.getSharedCode());
                itemReqDto.setSharedName(modifyReqDto.getSharedName());
                this.inventorySharedItemService.addInventorySharedItem(itemReqDto);
            }
        }
        if (CollectionUtil.isNotEmpty(warehouseIds = warehouseList.stream().map(InventorySharedWarehouseRespDto::getId).collect(Collectors.toList()))) {
            String warehouseIdsStr = StringUtils.join(warehouseIds, (String)",");
            this.inventorySharedWarehouseService.removeInventorySharedWarehouse(warehouseIdsStr, 0L);
        }
        for (InventorySharedWarehouseReqDto warehouseReqDto : modifyReqDto.getWarehouseList()) {
            warehouseReqDto.setSharedCode(modifyReqDto.getSharedCode());
            warehouseReqDto.setSharedName(modifyReqDto.getSharedName());
            this.inventorySharedWarehouseService.addInventorySharedWarehouse(warehouseReqDto);
        }
        String opContent = this.getModifyContent(inventorySharedRespDto, sharedItemList, warehouseList, modifyReqDto);
        InventorySharedOperationLogReqDto logReqDto = new InventorySharedOperationLogReqDto();
        logReqDto.setSharedCode(modifyReqDto.getSharedCode());
        logReqDto.setSharedName(modifyReqDto.getSharedName());
        logReqDto.setOperation("\u7f16\u8f91");
        logReqDto.setOpetationContent(opContent);
        this.inventorySharedOperationLogService.addInventorySharedOperationLog(logReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeInventoryShared(String ids) {
        List<InventorySharedRespDto> list = this.inventorySharedService.queryByIds(ids);
        this.inventorySharedService.removeInventoryShared(ids);
        for (InventorySharedRespDto dto : list) {
            InventorySharedOperationLogReqDto logReqDto = new InventorySharedOperationLogReqDto();
            logReqDto.setSharedCode(dto.getSharedCode());
            logReqDto.setSharedName(dto.getSharedName());
            logReqDto.setOperation("\u5220\u9664");
            logReqDto.setOpetationContent("\u5220\u9664\u89c4\u5219");
            this.inventorySharedOperationLogService.addInventorySharedOperationLog(logReqDto);
        }
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modifyInventorySharedStatus(String ids, String type) {
        List<InventorySharedRespDto> list = this.inventorySharedService.queryByIds(ids);
        AssertUtils.notEmpty(list, (String)"\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u4f9b\u8d27\u7b56\u7565");
        List<String> sharedCodes = list.stream().map(InventorySharedRespDto::getSharedCode).distinct().collect(Collectors.toList());
        this.inventorySharedService.modifyInventorySharedStatus(ids, type);
        List virtualWarehouseCodes = list.stream().map(InventorySharedRespDto::getVirtualWarehouseCode).distinct().collect(Collectors.toList());
        List virtualWarehouseEos = this.calcInventoryService.queryVirtualWarehouseEos(virtualWarehouseCodes);
        AssertUtils.notEmpty((Collection)virtualWarehouseEos, (String)"\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u4f9b\u8d27\u4ed3\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u4f9b\u8d27\u4ed3\u4fe1\u606f");
        List groupIds = virtualWarehouseEos.stream().filter(o -> Objects.nonNull(o.getGroupId())).map(VirtualWarehouseEo::getGroupId).distinct().collect(Collectors.toList());
        AssertUtils.notEmpty(groupIds, (String)"\u5173\u8054\u4f9b\u8d27\u4ed3\u4fe1\u606f, \uff0c\u4e0d\u5b58\u5728\u5206\u7ec4\u4fe1\u606f");
        List groupVirtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualWarehouseEo.class).in(VirtualWarehouseEo::getGroupId, groupIds)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        List groupVirtualWarehouseCodes = groupVirtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List<Long> groupVirtualWarehouseIds = groupVirtualWarehouseEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        String operation = "\u7981\u7528";
        String operationContent = "\u7981\u7528\u89c4\u5219";
        if (type.equals(EnableDisableEnum.ENABLE.getCode())) {
            operation = "\u542f\u7528";
            operationContent = "\u542f\u7528\u89c4\u5219";
            this.relVirtualWarehouseService.enable(Lists.newArrayList(), groupVirtualWarehouseIds);
            this.inventorySharedWarehouseService.enable(sharedCodes, Lists.newArrayList());
            this.calcInventoryService.refreshVirtualInventory((List)Lists.newArrayList(groupVirtualWarehouseCodes), (List)Lists.newArrayList());
        } else {
            List preemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).in(InventoryPreemptionEo::getWarehouseCode, groupVirtualWarehouseCodes)).eq(InventoryPreemptionEo::getWarehouseClassify, (Object)WarehouseClassifyEnum.VIRTUAL.getCode())).eq(InventoryPreemptionEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (CollectionUtils.isNotEmpty((Collection)preemptionEos)) {
                throw new CsInventoryException("\u8be5\u4f9b\u8d27\u7b56\u7565\u8fd8\u5b58\u5728\u9884\u5360\u8bb0\u5f55\uff0c\u4e0d\u53ef\u7981\u7528", new Object[0]);
            }
            this.calcInventoryService.clearVirtualInventory((List)Lists.newArrayList(groupVirtualWarehouseCodes), (List)Lists.newArrayList());
            this.relVirtualWarehouseService.disable(Lists.newArrayList(), groupVirtualWarehouseIds);
            this.inventorySharedWarehouseService.disable(sharedCodes, Lists.newArrayList());
        }
        for (InventorySharedRespDto dto : list) {
            InventorySharedOperationLogReqDto logReqDto = new InventorySharedOperationLogReqDto();
            logReqDto.setSharedCode(dto.getSharedCode());
            logReqDto.setSharedName(dto.getSharedName());
            logReqDto.setOperation(operation);
            logReqDto.setOpetationContent(operationContent);
            this.inventorySharedOperationLogService.addInventorySharedOperationLog(logReqDto);
        }
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> syncInventory(Long id) {
        InventorySharedEo inventorySharedEo = (InventorySharedEo)this.inventorySharedDomain.getMapper().selectById((Serializable)id);
        AssertUtils.notNull((Object)inventorySharedEo, (String)"\u5171\u4eab\u7b56\u7565\u67e5\u8be2\u4e0d\u5b58\u5728");
        this.calcInventoryService.refreshVirtualInventory((List)Lists.newArrayList((Object[])new String[]{inventorySharedEo.getVirtualWarehouseCode()}), null);
        return RestResponse.VOID;
    }

    public void checkParam(InventorySharedReqDto dto) {
        if ("part".equals(dto.getSharedItemScope()) && CollectionUtil.isEmpty((Collection)dto.getSharedItemList())) {
            throw new BizException("\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)dto.getWarehouseList())) {
            throw new BizException("\u5173\u8054\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String getModifyContent(InventorySharedRespDto inventorySharedRespDto, List<InventorySharedItemRespDto> sharedItemList, List<InventorySharedWarehouseRespDto> warehouseList, InventorySharedReqDto modifyReqDto) {
        String opContent = "";
        if (!inventorySharedRespDto.getSharedName().equals(modifyReqDto.getSharedName())) {
            opContent = opContent + "/\u7f16\u8f91\u89c4\u5219\u540d\u79f0";
        }
        if (!inventorySharedRespDto.getVirtualWarehouseName().equals(modifyReqDto.getVirtualWarehouseName())) {
            opContent = opContent + "/\u7f16\u8f91\u4e3b\u865a\u4ed3";
        }
        if (inventorySharedRespDto.getSharedNumerical().intValue() != modifyReqDto.getSharedNumerical().intValue()) {
            opContent = opContent + "/\u7f16\u8f91\u5171\u4eab\u6bd4\u4f8b";
        }
        if (CollectionUtil.isNotEmpty((Collection)modifyReqDto.getSharedItemList())) {
            List modifyItemList = modifyReqDto.getSharedItemList().stream().map(InventorySharedItemReqDto::getSkuCode).collect(Collectors.toList());
            for (InventorySharedItemRespDto sharedItem : sharedItemList) {
                if (modifyItemList.contains(sharedItem.getSkuCode())) continue;
                opContent = opContent + "/\u5220\u9664\u5546\u54c1";
                break;
            }
        }
        if (CollectionUtil.isNotEmpty(sharedItemList)) {
            List itemList = sharedItemList.stream().map(InventorySharedItemRespDto::getSkuCode).collect(Collectors.toList());
            for (InventorySharedItemReqDto modifyItem : modifyReqDto.getSharedItemList()) {
                if (itemList.contains(modifyItem.getSkuCode())) continue;
                opContent = opContent + "/\u6dfb\u52a0\u5546\u54c1";
                break;
            }
        }
        List modifyWarehouseList = modifyReqDto.getWarehouseList().stream().map(InventorySharedWarehouseReqDto::getWarehouseCode).collect(Collectors.toList());
        for (InventorySharedWarehouseRespDto warehouseItem : warehouseList) {
            if (modifyWarehouseList.contains(warehouseItem.getWarehouseCode())) continue;
            opContent = opContent + "/\u5220\u9664\u5b9e\u7269\u4ed3";
            break;
        }
        List wareList = warehouseList.stream().map(InventorySharedWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
        for (InventorySharedWarehouseReqDto modifyWarehouse : modifyReqDto.getWarehouseList()) {
            if (wareList.contains(modifyWarehouse.getWarehouseCode())) continue;
            opContent = opContent + "/\u6dfb\u52a0\u5b9e\u7269\u4ed3";
            break;
        }
        if (opContent.length() > 1) {
            opContent = opContent.substring(1);
        }
        return opContent;
    }

    public RestResponse<InventorySharedRespDto> queryById(Long id) {
        InventorySharedRespDto inventorySharedRespDto = this.inventorySharedService.queryById(id);
        if ("part".equals(inventorySharedRespDto.getSharedItemScope())) {
            List sharedItemList = this.inventorySharedItemService.queryByPage("{sharedCode:'" + inventorySharedRespDto.getSharedCode() + "'}", 1, 10000).getList();
            inventorySharedRespDto.setSharedItemList(sharedItemList);
        }
        List warehouseList = this.inventorySharedWarehouseService.queryByPage("{sharedCode:'" + inventorySharedRespDto.getSharedCode() + "'}", 1, 10000).getList();
        inventorySharedRespDto.setWarehouseList(warehouseList);
        return new RestResponse((Object)inventorySharedRespDto);
    }

    public RestResponse<PageInfo<InventorySharedRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.inventorySharedService.queryByPage(filter, pageNum, pageSize));
    }
}

