/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.CargoStorageTotalReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.CargoStorageTotalRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelInventoryQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventoryChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelInventoryQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.RelShareInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IChannelInventoryService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.domain.entity.IChannelInventoryDomain;
import com.yunxi.dg.base.center.share.domain.entity.IChannelWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IRelVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IRelWarehouseChannelDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualInventoryDomain;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.center.share.dto.InventorySummaryRespDto;
import com.yunxi.dg.base.center.share.enums.ShareWarehouseTypeEnum;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.RelVirtualWarehouseEo;
import com.yunxi.dg.base.center.share.eo.RelWarehouseChannelEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.share.service.entity.IChannelWarehouseService;
import com.yunxi.dg.base.center.share.service.entity.IRelShareInventoryService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bizChannelInventoryService")
public class ChannelInventoryServiceImpl
implements IChannelInventoryService {
    private static final Logger log = LoggerFactory.getLogger(ChannelInventoryServiceImpl.class);
    @Autowired
    IChannelInventoryDomain channelInventoryDomain;
    @Autowired
    IRelWarehouseChannelDomain relWarehouseChannelDomain;
    @Autowired
    IRelShareInventoryService relShareInventoryService;
    @Autowired
    IChannelWarehouseService channelWarehouseService;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;
    @Autowired
    ICacheService cacheService;
    @Autowired
    IRelVirtualWarehouseDomain relVirtualWarehouseDomain;
    @Autowired
    IVirtualInventoryDomain virtualInventoryDomain;
    @Autowired
    IChannelWarehouseDomain channelWarehouseDomain;
    @Autowired
    IChannelInventoryService channelInventoryService;

    @Override
    public ChannelInventoryRespDto queryById(Long id) {
        ChannelInventoryEo channelInventoryEo = (ChannelInventoryEo)this.channelInventoryDomain.selectByPrimaryKey(id);
        ChannelInventoryRespDto channelInventoryRespDto = new ChannelInventoryRespDto();
        DtoHelper.eo2Dto((BaseEo)channelInventoryEo, (BaseVo)channelInventoryRespDto);
        return channelInventoryRespDto;
    }

    @Override
    public PageInfo<ChannelInventoryRespDto> queryByPage(InventoryQueryReqDto inventoryQueryReqDto) {
        ExtQueryChainWrapper filter = this.channelInventoryDomain.filter();
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getCargoCode())) {
            filter.like((Object)"sku_code", (Object)inventoryQueryReqDto.getCargoCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getCargoName())) {
            filter.like((Object)"sku_name", (Object)inventoryQueryReqDto.getCargoName());
        }
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getWarehouseCode())) {
            filter.like((Object)"warehouse_code", (Object)inventoryQueryReqDto.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getWarehouseName())) {
            filter.like((Object)"warehouse_name", (Object)inventoryQueryReqDto.getWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getSearchDimension())) {
            Assert.isTrue((inventoryQueryReqDto.getMinQuantity() != null || inventoryQueryReqDto.getMaxQuantity() != null ? 1 : 0) != 0, (String)"\u6700\u5927\u503c\u6570\u91cf\u548c\u6700\u5c0f\u6570\u91cf\u90fd\u4e3a\u65e0\u6548\u503c", (Object[])new Object[0]);
            if (inventoryQueryReqDto.getMinQuantity() != null) {
                filter.ge((Object)inventoryQueryReqDto.getSearchDimension(), (Object)inventoryQueryReqDto.getMinQuantity());
            }
            if (inventoryQueryReqDto.getMaxQuantity() != null) {
                filter.le((Object)inventoryQueryReqDto.getSearchDimension(), (Object)inventoryQueryReqDto.getMaxQuantity());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)inventoryQueryReqDto.getWarehouseCodes())) {
            List channelWarehouseEos = this.channelWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", (Collection)inventoryQueryReqDto.getWarehouseCodes())).eq((Object)"warehouse_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (CollectionUtils.isEmpty((Collection)channelWarehouseEos)) {
                return new PageInfo();
            }
            List warehouseCodes = channelWarehouseEos.stream().map(ChannelWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
            inventoryQueryReqDto.setWarehouseCodes(warehouseCodes);
        }
        filter.in(CollectionUtils.isNotEmpty((Collection)inventoryQueryReqDto.getWarehouseCodes()), (Object)"warehouse_code", (Collection)inventoryQueryReqDto.getWarehouseCodes());
        filter.in(CollectionUtils.isNotEmpty((Collection)inventoryQueryReqDto.getCargoCodes()), (Object)"sku_code", (Collection)inventoryQueryReqDto.getCargoCodes());
        PageInfo eoPageInfo = filter.page(inventoryQueryReqDto.getPageNum(), inventoryQueryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List eoList = eoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return dtoPageInfo;
        }
        Set skuCodes = eoList.stream().map(ChannelInventoryEo::getSkuCode).collect(Collectors.toSet());
        Set channelWarehouseIds = eoList.stream().map(ChannelInventoryEo::getWarehouseId).collect(Collectors.toSet());
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(RelVirtualWarehouseEo::getChannelWarehouseId, channelWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            return dtoPageInfo;
        }
        Set virtualWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).collect(Collectors.toSet());
        List virtualInventoryEos = this.virtualInventoryDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_id", virtualWarehouseIds)).in((Object)"sku_code", skuCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)virtualInventoryEos)) {
            return dtoPageInfo;
        }
        ArrayList<ChannelInventoryRespDto> dtoList = new ArrayList<ChannelInventoryRespDto>();
        for (ChannelInventoryEo eo : eoList) {
            ChannelInventoryRespDto dto = new ChannelInventoryRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)dto);
            dto.setLongCode(eo.getSkuCode());
            dto.setCargoCode(eo.getSkuCode());
            dto.setCargoName(eo.getSkuName());
            List channelRelVirtualEos = relVirtualWarehouseEos.stream().filter(o -> Objects.equals(eo.getWarehouseId(), o.getChannelWarehouseId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(channelRelVirtualEos)) continue;
            ArrayList relShareInventoryRespDtoList = Lists.newArrayList();
            for (RelVirtualWarehouseEo relVirtualWarehouseEo : channelRelVirtualEos) {
                RelShareInventoryRespDto relShareInventoryRespDto = new RelShareInventoryRespDto();
                relShareInventoryRespDto.setId(relVirtualWarehouseEo.getId());
                relShareInventoryRespDto.setAvailable(BigDecimal.ZERO);
                relShareInventoryRespDto.setPreempt(BigDecimal.ZERO);
                relShareInventoryRespDto.setBalance(BigDecimal.ZERO);
                relShareInventoryRespDto.setShareWarehouseType(ShareWarehouseTypeEnum.TO_CHANNEL.getCode());
                relShareInventoryRespDto.setReceiveWarehouseCode(eo.getWarehouseCode());
                relShareInventoryRespDto.setCargoCode(eo.getSkuCode());
                VirtualInventoryEo virtualInventoryEo = virtualInventoryEos.stream().filter(o -> Objects.equals(o.getWarehouseId(), relVirtualWarehouseEo.getVirtualWarehouseId()) && StringUtils.equals((CharSequence)eo.getSkuCode(), (CharSequence)o.getSkuCode())).findFirst().orElse(null);
                if (null != virtualInventoryEo) {
                    relShareInventoryRespDto.setShareWarehouseCode(virtualInventoryEo.getWarehouseCode());
                    relShareInventoryRespDto.setBalance(virtualInventoryEo.getBalance());
                    relShareInventoryRespDto.setAvailable(virtualInventoryEo.getAvailable());
                }
                relShareInventoryRespDtoList.add(relShareInventoryRespDto);
            }
            dto.setRelShareInventoryList((List)relShareInventoryRespDtoList);
            dtoList.add(dto);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ChannelInventoryQueryRespDto> queryByItem(ChannelInventoryQueryReqDto channelInventoryQueryReqDto) {
        Assert.notNull((Object)channelInventoryQueryReqDto, (String)"\u67e5\u8be2\u5bf9\u8c61\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)channelInventoryQueryReqDto.getChannelCode(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.notEmpty((Iterable)channelInventoryQueryReqDto.getSkuCodes(), (String)"sku\u7f16\u7801\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ArrayList<ChannelInventoryQueryRespDto> channelInventoryQueryRespDtos = new ArrayList<ChannelInventoryQueryRespDto>();
        RelWarehouseChannelEo relWarehouseChannelEo = (RelWarehouseChannelEo)((ExtQueryChainWrapper)this.relWarehouseChannelDomain.filter().eq((Object)"channel_code", (Object)channelInventoryQueryReqDto.getChannelCode())).one();
        if (ObjectUtils.isNotEmpty((Object)relWarehouseChannelEo)) {
            List channelInventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.channelInventoryDomain.filter().eq((Object)"warehouse_id", (Object)relWarehouseChannelEo.getWarehouseId())).in((Object)"sku_code", (Collection)channelInventoryQueryReqDto.getSkuCodes())).list();
            DtoHelper.eoList2DtoList((Collection)channelInventoryEos, channelInventoryQueryRespDtos, ChannelInventoryQueryRespDto.class);
        }
        return channelInventoryQueryRespDtos;
    }

    @Override
    public ChannelInventoryRespDto queryByCargoCode(String cargoCode, String warehouseCode) {
        Assert.notNull((Object)cargoCode, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)warehouseCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ChannelInventoryEo channelInventoryEo = (ChannelInventoryEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.channelInventoryDomain.filter().eq((Object)"sku_code", (Object)cargoCode)).eq((Object)"warehouse_code", (Object)warehouseCode)).one();
        if (ObjectUtils.isEmpty((Object)channelInventoryEo)) {
            return null;
        }
        ChannelInventoryRespDto channelInventoryRespDto = new ChannelInventoryRespDto();
        DtoHelper.eo2Dto((BaseEo)channelInventoryEo, (BaseVo)channelInventoryRespDto);
        return channelInventoryRespDto;
    }

    @Override
    public List<ChannelInventoryRespDto> queryByCargoCodes(List<String> cargoCodes, String warehouseCode) {
        List channelInventoryEo;
        Assert.isTrue((CollectionUtils.isNotEmpty(cargoCodes) || StringUtils.isNotEmpty((CharSequence)warehouseCode) ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ExtQueryChainWrapper filter = this.channelInventoryDomain.filter();
        if (CollectionUtils.isNotEmpty(cargoCodes)) {
            filter.in((Object)"sku_code", cargoCodes);
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseCode)) {
            filter.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (ObjectUtils.isEmpty((Object)(channelInventoryEo = filter.list()))) {
            return null;
        }
        ArrayList<ChannelInventoryRespDto> channelInventoryRespDtos = new ArrayList<ChannelInventoryRespDto>();
        DtoHelper.eoList2DtoList((Collection)channelInventoryEo, channelInventoryRespDtos, ChannelInventoryRespDto.class);
        return channelInventoryRespDtos;
    }

    @Override
    public void initByVirtualInventoryChange(List<InventoryChangeReqDto> inventoryChangeReqDtos) {
    }

    @Override
    public InventorySummaryRespDto querySummary(InventoryQueryReqDto reqDto) {
        return this.channelInventoryDomain.querySummary(reqDto);
    }

    @Override
    public PageInfo<CargoStorageTotalRespDto> queryInventoryItemSku(CargoStorageTotalReqDto reqDto) {
        PageInfo pageInfo = new PageInfo();
        Integer pageNum = reqDto.getPageNum();
        Integer pageSize = reqDto.getPageSize();
        if (null == pageNum) {
            pageNum = 1;
        }
        if (null == pageSize) {
            pageSize = 10;
        }
        String channelWarehouseCode = reqDto.getWarehouseCode();
        AssertUtils.notBlank((String)channelWarehouseCode, (String)"\u6ca1\u6709\u6709\u6548\u6e20\u9053\u4ed3\u7f16\u7801");
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.channelInventoryDomain.filter().eq((Object)"warehouse_code", (Object)channelWarehouseCode)).like(StringUtils.isNotBlank((CharSequence)reqDto.getCargoName()), (Object)"sku_name", (Object)reqDto.getCargoName())).like(StringUtils.isNotBlank((CharSequence)reqDto.getCargoCode()), (Object)"sku_code", (Object)reqDto.getCargoCode())).page(pageNum, pageSize);
        BeanUtils.copyProperties((Object)eoPageInfo, (Object)pageInfo, (String[])new String[]{"list"});
        if (Objects.equals(eoPageInfo.getTotal(), 0L)) {
            return pageInfo;
        }
        List eoList = eoPageInfo.getList();
        ArrayList dtoList = Lists.newArrayList();
        for (ChannelInventoryEo eo : eoList) {
            CargoStorageTotalRespDto dto = new CargoStorageTotalRespDto();
            dto.setId(eo.getId());
            dto.setCargoCode(eo.getSkuCode());
            dto.setCargoName(eo.getSkuName());
            dto.setLongCode(eo.getSkuCode());
            dto.setBalance(eo.getBalance());
            dto.setAvailable(eo.getAvailable());
            dto.setPreempt(eo.getPreempt());
            dtoList.add(dto);
        }
        pageInfo.setList((List)dtoList);
        return pageInfo;
    }
}

