/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.CargoStorageTotalReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.CargoStorageTotalRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelInventoryQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventoryChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelInventoryQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelInventoryRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.center.share.dto.InventorySummaryRespDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/channelInventory"})
public class ChannelInventoryRest
implements IChannelInventoryApi {
    @Resource(name="${yunxi.dg.base.project}_ChannelInventoryApi")
    IChannelInventoryApi channelInventoryApi;

    public RestResponse<ChannelInventoryRespDto> queryById(@PathVariable(value="id") Long id) {
        return this.channelInventoryApi.queryById(id);
    }

    public RestResponse<List<ChannelInventoryQueryRespDto>> queryByItem(@Validated @RequestBody ChannelInventoryQueryReqDto channelInventoryQueryReqDto) {
        return this.channelInventoryApi.queryByItem(channelInventoryQueryReqDto);
    }

    public RestResponse<List<ChannelInventoryRespDto>> queryByCargoCodes(@RequestParam List<String> cargoCodes, @RequestParam String warehouseCode) {
        return this.channelInventoryApi.queryByCargoCodes(cargoCodes, warehouseCode);
    }

    public RestResponse<PageInfo<CargoStorageTotalRespDto>> queryInventoryItemSku(@Validated @RequestBody CargoStorageTotalReqDto reqDto) {
        return this.channelInventoryApi.queryInventoryItemSku(reqDto);
    }

    public RestResponse<Void> initByVirtualInventoryChange(@Validated @RequestBody List<InventoryChangeReqDto> inventoryChangeReqDtos) {
        return this.channelInventoryApi.initByVirtualInventoryChange(inventoryChangeReqDtos);
    }

    public RestResponse<InventorySummaryRespDto> querySummary(@Validated @RequestBody InventoryQueryReqDto reqDto) {
        return this.channelInventoryApi.querySummary(reqDto);
    }

    public RestResponse<Void> preempt(@RequestBody PreemptDto param) {
        return this.channelInventoryApi.preempt(param);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> releasePreempt(@RequestBody ReleasePreemptDto param) {
        return this.channelInventoryApi.releasePreempt(param);
    }
}

