/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.WarehouseRelationReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.WarehouseRelationRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/channelWarehouse"})
public class ChannelWarehouseRest
implements IChannelWarehouseApi {
    @Resource(name="${yunxi.dg.base.project}_ChannelWarehouseApi")
    IChannelWarehouseApi channelWarehouseApi;

    public RestResponse<Long> add(@Validated @RequestBody ChannelWarehouseAddReqDto addReqDto) {
        return this.channelWarehouseApi.add(addReqDto);
    }

    public RestResponse<Void> update(@PathVariable(value="id") Long id, @Validated @RequestBody ChannelWarehouseUpdateReqDto updateReqDto) {
        AssertUtils.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u9519\u8bef");
        return this.channelWarehouseApi.update(id, updateReqDto);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> updateByWarehouseCode(@PathVariable(value="warehouseCode") String warehouseCode, ChannelWarehouseUpdateReqDto updateReqDto) {
        AssertUtils.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{warehouseCode}), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.channelWarehouseApi.updateByWarehouseCode(warehouseCode, updateReqDto);
    }

    public RestResponse<Void> delete(@PathVariable(value="id") Long id) {
        AssertUtils.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u9519\u8bef");
        return this.channelWarehouseApi.delete(id);
    }

    public RestResponse<Void> rebuildShareInventory(@RequestParam(value="warehouseCode") String warehouseCode) {
        return this.channelWarehouseApi.rebuildShareInventory(warehouseCode);
    }

    public RestResponse<ChannelWarehouseRespDto> queryByPrimaryKey(@PathVariable(value="id") Long id) {
        return this.channelWarehouseApi.queryByPrimaryKey(id);
    }

    public RestResponse<ChannelWarehouseRespDto> queryByChannelCode(@RequestParam(value="channelCode") String channelCode) {
        return this.channelWarehouseApi.queryByChannelCode(channelCode);
    }

    public RestResponse<ChannelWarehouseRespDto> queryByWarehouseCode(@PathVariable(value="warehouseCode") String warehouseCode) {
        return this.channelWarehouseApi.queryByWarehouseCode(warehouseCode);
    }

    public RestResponse<Boolean> checkWarehouseCode(@RequestParam(value="warehouseCode") String warehouseCode) {
        AssertUtils.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{warehouseCode}), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.channelWarehouseApi.checkWarehouseCode(warehouseCode);
    }

    public RestResponse<Boolean> checkChannelWarehouseOverall(@RequestParam(value="warehouseCode") Long groupId) {
        return this.channelWarehouseApi.checkChannelWarehouseOverall(groupId);
    }

    public RestResponse<PageInfo<ChannelWarehousePageRespDto>> queryByPage(@Validated @RequestBody ChannelWarehouseQueryDto queryDto) {
        return this.channelWarehouseApi.queryByPage(queryDto);
    }

    public RestResponse<List<ChannelWarehouseRespDto>> queryByCodes(@Validated @RequestBody Set<String> channelWarehouseCodes) {
        return this.channelWarehouseApi.queryByCodes(channelWarehouseCodes);
    }

    public RestResponse<Map<String, List<ChannelWarehouseRespDto>>> queryByLogicWarehouseCodes(@RequestBody Set<String> logicWarehouseCodes) {
        return this.channelWarehouseApi.queryByLogicWarehouseCodes(logicWarehouseCodes);
    }

    public RestResponse<PageInfo<WarehouseRelationRespDto>> queryWarehouseRelation(@RequestBody WarehouseRelationReqDto queryDto) {
        return this.channelWarehouseApi.queryWarehouseRelation(queryDto);
    }
}

