/**
 * @(#) IRegisterApi.java 1.0 2018-08-30
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.MemberRegisterReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.ResetPasswordReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 用户注册 API接口类
 *
 * @author 项羽
 * @since 2.0.0
 */
@Api(tags = {"认证中心：注册服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-IRegisterApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v2/user", url = "${yundt.cube.center.identity.api:}")
public interface IRegisterApi {
    /**
     * 新增注册 包含校验用户名或者手机邮箱是否存在
     *
     * @param user UserReqDto
     * @return String 数据保存后的ID
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "用户注册", notes = ""
            + "认证中心发起用户注册请求调用用户保存接口保存用户注册信息。支持1手机+验证码注册,2手机+验证码+密码注册,3邮箱注册+密码注册,验证码激活4用户名+密码注册" + "/n 密码需要用MD5加密")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "body", name = "user", dataType = "UserReqDto", required = true, value = "用户注册信息")})
    RestResponse<String> register(@Valid @RequestBody UserReqDto user);


    /**
     * 会员注册接口，聚合接口包含用户注册及会员注册
     *
     * @param dto 注册实体
     * @return
     */

    @ApiOperation(value = "注册用户并激活会员", notes = "若要导入会员信息,需要到nacos,DataId:yundt-cube-center-identity.yaml配置\n" +
            "格式参考:\n" +
            "yundt.cube.center.member.memberModels:\n" +
            "   - instanceId: 1192553087396520965\n" +
            "     modelId:\n" +
            "     - modelId: 1203741353161093206\n" +
            "       levelIds: 1202785443138116678\n" +
            "     - modelId: 1203741405839454219\n" +
            "       levelIds: 1202785468193840233  \n" +
            "入参Dto的tenantId与体系对应的tenantId相同时才会进行会员数据新增\n" +
            "认证中心发起用户注册请求调用用户保存接口保存用户注册信息,并激活会员账号" +
            "。支持1手机+验证码注册,2手机+验证码+密码注册,3邮箱注册+密码注册,验证码激活4用户名+密码注册" + "/n 密码需要用MD5加密")
    @PostMapping(value = "register", produces = "application/json")
    RestResponse<Long> register(@Valid @RequestBody MemberRegisterReqDto dto);

    /**
     * 导入用户，并激活会员
     *
     * @param dto 注册实体
     * @return
     */
    @PostMapping(value = "import", produces = "application/json")
    @ApiOperation(value = "导入用户，并激活会员", notes = "导入用户，并激活会员")
    RestResponse<Long> importUserAndMember(@Valid @RequestBody MemberRegisterReqDto dto);

    /**
     * 用户通过手机号码重置密码
     *
     * @param resetPasswordReqDto
     * @return
     */
    @PutMapping(value = "/password/reset", produces = "application/json")
    @ApiOperation(value = "通过手机号码重置密码", notes = "通过手机号码重置密码")
    RestResponse<Void> resetPassword(@Valid @RequestBody ResetPasswordReqDto resetPasswordReqDto);

}
