/**
 * @(#) IThirdLoginApi.java 1.0 2018-09-17
 *
 * Copyright  (c)  2017,  YUNXI.  All  rights  reserved.
 * YUNXI  PROPRIETARY/CONFIDENTIAL.  Use  is  subject  to  license  terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.BindLoginWithoutAccessTokenDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

/**
 * @author 项羽
 * @since 2.0.0
 */
@Api(tags = { "认证中心：第三方登录认证" })
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-IThirdLoginApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v2/oauth2", url = "${yundt.cube.center.identity.api:}")
public interface IThirdLoginApi {

	/**
	 * 第三方登录通过认证中心发起申请
	 * 
	 * @author 项羽
	 * @since 2.0.0
	 * @param authReqDto 申请获取授权码url的请求Dto
	 * @return 返回第三方的授权码申请url
	 */
	@ApiOperation(value = "step1：返回向第三方申请授权码code的url", notes = "业务应用中心向第三方发起用户认证请求，返回向第三方申请授权码code的url，申请获取授权码code后通过step2传递给认证中心")
	@PostMapping(value = "", produces = "application/json")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "authReqDto", value = "申请第三方授权码url的DTO", dataType = "AuthLoginReqDto", paramType = "body", required = false, example = "abc") })
	RestResponse<ThirdUserInfoRespDto> thirdAuth(@RequestBody AuthLoginReqDto authReqDto);

	/**
	 * 第三方登录认证通过后的申请认证中心token
	 * 
	 * @author 项羽
	 * @since 2.0.0
	 * @param authTokenReqDto 包含第三方授权码和重定向地址的请求Dto
	 * @return 返回第三方accessToken和openId，或者返回认证中心token
	 */
	@ApiOperation(value = "step2：返回从第三方获取的access_token和用户openID", notes = "用户授权登录后，通过认证中心从第三方获取access_token和用户openID并返回,\n" +
			"若之前已经绑定,则直接返回认证中心token")
	@PostMapping(value = "/token", produces = "application/json")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "authTokenReqDto", value = "申请第三方access_token和openID的DTO", dataType = "AuthLoginTokenReqDto", paramType = "body", required = false, example = "abc") })
	RestResponse<ThirdLoginRespDto> tokenAuth(@RequestBody AuthLoginTokenReqDto authTokenReqDto);

	/**
	 * 绑定第三方并且返回token
	 * 
	 * @param user
	 *            绑定第三方并且返回token
	 * @return 返回认证中心token
	 */
	@PostMapping("/bind/login")
	@ApiOperation(value = "step3：在用户中心为手机建立绑定关系并返回认证中心的token", notes = "通过认证中心发起请求，在用户中心为手机新建用户（若不存在）、绑定手机和openId/unionId，并且返回认证中心的token")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "user", value = "绑定请求DTO", dataType = "UserBindLoginThirdDto", paramType = "body", example = "/11213213/user/222/token") })
	RestResponse<TokenRespDto> bindLogin(@Valid @RequestBody UserBindLoginThirdDto user);

	/**
	 * 绑定第三方并且返回token
	 *
	 * @param user
	 *            轻量级第三方绑定登录请求DTO
	 * @return 返回认证中心token
	 */
	@PostMapping("/bind/lightweight-login")
	@ApiOperation(value = "绑定第三方openId/unionId并且登录", notes = "绑定第三方openId/unionId并且登录(轻量级第三方绑定并登录)")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "user", value = "绑定请求DTO", dataType = "BindLoginWithoutAccessTokenDto", paramType = "body") })
	RestResponse<TokenRespDto> bindLoginWithoutAccessToken(@Valid @RequestBody BindLoginWithoutAccessTokenDto user);

	/**
	 * 接收微信网页授权code,重定向到redirectUri
	 *
	 * @param code 微信网页授权code
	 * @param uriKey 前端回调地址cache key
	 * @param httpServletResponse
	 * @return
	 */
	@GetMapping("/code")
	@ApiOperation(value = "接收微信网页授权code,重定向到redirectUri", notes = "因为前端redirectUri中带有#号，微信重定向会丢失，所以后端服务重定向")
	RestResponse<Void> redirectUri(@RequestParam("code") String code, @RequestParam("uriKey") String uriKey, HttpServletResponse httpServletResponse);
}
