/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.CheckTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.LoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.RefreshTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.LoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.RefreshTokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.SsoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Map;

/**
 * token管理api(登录创建api)
 *
 * @author 简树
 * @since 2.0.0
 */
@Api(tags = { "认证中心：token服务" })
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-ITokenApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v2/user", url = "${yundt.cube.center.identity.api:}")
public interface ITokenApi {
	/**
	 * 检验token
	 *
	 * @param token
	 *            传入 token
	 * @return 返回检验结果
	 */
	@Deprecated
	@GetMapping("/token/{token}/isvalid")
	@ApiOperation(value = "检验令牌有效性", notes = "检验令牌有效性")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "token", value = "令牌token", dataType = "string", paramType = "path", required = true, example = "/user/token/2222/isvalid") })
	RestResponse<Map<String, Object>> checkToken(@PathVariable("token") String token);
//	/**
//	 * 解析token信息
//	 *
//	 * @param token
//	 *            传入 token
//	 * @return 返回检验结果
//	 */
//	@GetMapping("/token/{token}/parse")
//	@ApiOperation(value = "解析token信息", notes = "解析token信息")
//	@ApiImplicitParams({
//			@ApiImplicitParam(name = "token", value = "令牌token", dataType = "string", paramType = "path", required = true, example = "/user/token/2222/parse") })
//	RestResponse<Map<String, Object>> parseToken(@PathVariable("token") String token);

    /**
     * 检验token
     *
     * @param checkTokenReqDto
     *            传入 token
     * @return 返回检验结果
     */
    @PostMapping("/token/isvalid")
    @ApiOperation(value = "检验令牌有效性", notes = "检验令牌有效性")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "checkTokenReqDto", value = "令牌token", dataType = "CheckTokenReqDto", paramType = "body") })
    RestResponse<Map<String, Object>> checkToken(@Valid @RequestBody CheckTokenReqDto checkTokenReqDto);

	/**
	 * 注销token
	 *
	 * @param userId
	 *            用户id
	 * @return 无
	 */
	@DeleteMapping("/{userId}/token")
	@ApiOperation(value = "注销令牌", notes = " 注销令牌")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "userId", value = "用户id", dataType = "string", paramType = "path", required = true, example = "/11213213/user/222/token") })
	RestResponse<Void> deleteToken(@PathVariable("userId") String userId);


	/**
	 * 注销登录的令牌
	 * @param userId 用户id
     * @param loginSource 登录来源
	 */
	@DeleteMapping("/{userId}/login-source/{loginSource}")
	@ApiOperation(value = "根据用户和登录来源注销令牌", notes = "根据用户和登录来源注销令牌")
	@ApiImplicitParams({
			@ApiImplicitParam(name="userId",value="用户id",dataType="string", paramType = "path",required = true),
			@ApiImplicitParam(name="loginSource",value="登录来源",dataType="string", paramType = "path",required = true)
	})
	RestResponse<Void> deleteLoginToken(@PathVariable("userId") String userId, @PathVariable("loginSource") String loginSource);

	/**
	 * 申请令牌
	 *
	 * @param user
	 *            登录用户信息
	 * @return 返回认证中心token
	 */
	@PostMapping("/token")
	@ApiOperation(value = "申请令牌", notes = "创建token,当登录错误次数过多时需要输入验证码，可以用返回结果的flag来知道是否需要输入验证码。重新获取验证可以调用：验证码发送和校验服务-》发送生成的图片验证码信息 重新获取验证码")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "user", value = "用户登录参数", dataType = "UserLoginReqDto", paramType = "body", example = "/11213213/user/222/token") })
	RestResponse<TokenRespDto> createToken(@Valid @RequestBody UserLoginReqDto user);

	/**
	 * SSO申请令牌
	 * @param user 登录用户信息
	 * @return
	 */
	@PostMapping("/sso/token")
	@ApiOperation(value = "SSO申请令牌", notes = "注销SSO令牌,当用户申请一次token后,在其他关联应用中无需再次登录\n" +
			"创建token,当登录错误次数过多时需要输入验证码，可以用返回结果的flag来知道是否需要输入验证码。重新获取验证可以调用：验证码发送和校验服务-》发送生成的图片验证码信息 重新获取验证码")
	@ApiImplicitParams({
			@ApiImplicitParam(name="user",value="用户登录参数",dataType="UserLoginReqDto", paramType = "body")
	})
	RestResponse<TokenRespDto> createSsoToken(@Valid @RequestBody UserLoginReqDto user);

	/**
	 * 注销SSO令牌
	 * @param appKey appKey
	 * @param token token
	 */
	@DeleteMapping("/appkey/{appKey}/token/{token:.+}")
	@ApiOperation(value = "注销SSO令牌", notes = " 注销SSO令牌")
	@ApiImplicitParams({
			@ApiImplicitParam(name="appKey",value="appKey",dataType="string", paramType = "path",required = true),
			@ApiImplicitParam(name="token",value="token",dataType="string", paramType = "path",required = true)
	})
	RestResponse<Void> deleteSsoToken(@PathVariable("appKey")String appKey,@PathVariable("token")String token);

	/**
	 * 用户登录
	 *
	 * @param loginReqDto
	 * @return
	 */
	@ApiOperation(value = "用户登录，给B端登录或boc用,  C端消费者登录推荐使用ITokenApi#createToken", notes = "用户登录，给B端登录或boc用,  C端消费者登录推荐使用#createToken")
	@PostMapping(value = "/login", consumes = "application/json", produces = "application/json")
	RestResponse<LoginRespDto> login(@Valid @RequestBody LoginReqDto loginReqDto);

	/**
	 * BOC统一登录，BOC应用专用
	 *
	 * @param userLoginReqDto 用户登录信息
	 * @return BOC统一登录响应dto
	 */
	@ApiOperation(value = "BOC统一登录，BOC应用专用", notes = "BOC统一登录，BOC应用专用")
	@PostMapping(value = "/sso/login", consumes = "application/json", produces = "application/json")
	RestResponse<SsoRespDto> ssoLogin(@Valid @RequestBody UserLoginReqDto userLoginReqDto);

	/**
	 * 刷新token
	 *
	 * @param refreshTokenReqDto 旧token
	 * @return 新token
	 */
	@ApiOperation(value = "刷新token", notes = "刷新token")
	@PostMapping(value = "/refresh/token")
	RestResponse<RefreshTokenRespDto> refreshToken(@Valid @RequestBody RefreshTokenReqDto refreshTokenReqDto);

}
