/*
 * *
 *  * @(#)AuthConstants.java 2.0.0 18-9-20 上午9:40
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.cube.center.identity.api.constants;

/**
 * 用户验证相关常量定义
 *
 * @author 飞扬
 */
public interface AuthConstants {
    /**
     * 请求头中记录用户token的key
     */
    String ACCESS_TOKEN = "Access-Token";

    /**
     * 请求头中记录应用实例ID的key
     */
    String APPLICATION_KEY = "Application-Key";

    /**
     * 第三方登录，回调地址
     */
    String LOGIN_WEB_PARAM_REDIRECT_URI = "redirectUri";

    /**
     * QQ第三方登录，申请授权码url的参数state
     */
    String QQ_LOGIN_WEB_PARAM_STATE = "state";

    /**
     * QQ第三方登录，申请授权码url的参数scope
     */
    String QQ_LOGIN_WEB_PARAM_SCOPE = "scope";

    /**
     * QQ第三方登录，申请授权码url的参数display
     */
    String QQ_LOGIN_WEB_PARAM_DISPLAY = "display";

    /**
     * 资源类型-实例
     */
    int RES_INSTANCE = 3;

    /**
     * 第三方开发者配置级别-租户级别
     */
    int CONFIG_LEVEL_TENANT = 1;

    /**
     * 第三方开发者配置级别-应用实例级别
     */
    int CONFIG_LEVEL_INSTANCE = 2;

}
