package com.dtyunxi.yundt.cube.center.identity.api.constants;

import java.util.HashMap;
import java.util.Map;

public enum NewValidWayType {

    /**
     * 滑块验证
     */
    SLIDER_VALIDATION(0),

    /**
     * 手机验证码
     */
    PHONE_VALID_CODE(1),
    /**
     * 用户冻结
     */
    USER_FREEZE(2);

    private static Map<Integer, NewValidWayType> codeMapping = new HashMap<>();

    static {
        for (NewValidWayType type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    NewValidWayType(int code) {
        this.code = code;
    }

    public static NewValidWayType fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}