/**
 * @(#) OAuthLoginReqDto.java 1.0 2018-09-20
 * <p>
 * Copyright  (c)  2017,  YUNXI.  All  rights  reserved.
 * YUNXI  PROPRIETARY/CONFIDENTIAL.  Use  is  subject  to  license  terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 第三方登录请求发起Dto
 *
 * @author 项羽
 * @since 2.0.0
 */
@ApiModel(value = "AuthLoginReqDto", description = "第三方登录请求发起Dto")
public class AuthLoginReqDto extends RequestDto {
    private static final long serialVersionUID = -4601655295390564328L;

    @ApiModelProperty(value = "第三方用户来源（1：微信，2：QQ，3：Sina微博，4：钉钉，5：FACEBOOK 6：微信小程序 7：苹果  9:支付宝）, 必填")
    @NotNull
    @Min(1)
    @Max(10)
    private Integer thirdType;

    @ApiModelProperty(value = "登录来源：（1.网站 2.应用 3.小程序）。当第三方用户来源有多个登录来源时使用，如微信，有app微信登录，微信小程序登录。与com.dtyunxi.yundt.cube.center.identity.api.dto.request#UserLoginReqDto无关联。选填")
    private Integer loginSource;

    @NotNull
    @ApiModelProperty(value = "前端请求登录同意授权后的跳转uri, 必填")
    private String redirectUri;

    @ApiModelProperty(value = "配置级别：1 租户级别 2 应用级别, 选填")
    private Integer configLevel;

    @ApiModelProperty(value = "微信回调时的state值，默认值为state")
    private String state;

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Integer getThirdType() {
        return thirdType;
    }

    public void setThirdType(Integer thirdType) {
        this.thirdType = thirdType;
    }

    public String getRedirectUri() {
        return redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public Integer getLoginSource() {
        return loginSource;
    }

    public Integer getConfigLevel() {
        return configLevel;
    }

    public void setConfigLevel(Integer configLevel) {
        this.configLevel = configLevel;
    }

    public void setLoginSource(Integer loginSource) {
        this.loginSource = loginSource;
    }
}
