/**
 * @(#) OAuthLoginReqDto.java 1.0 2018-09-20
 *
 * Copyright  (c)  2017,  YUNXI.  All  rights  reserved.
 * YUNXI  PROPRIETARY/CONFIDENTIAL.  Use  is  subject  to  license  terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 第三方登录发起请求TokenDto
 * 
 * @author 项羽
 * @since 2.0.0
 */
@ApiModel(value = "AuthLoginTokenReqDto", description = "第三方登录确认授权后发起请求TokenDto")
public class AuthLoginTokenReqDto extends RequestDto {
	private static final long serialVersionUID = -4601655295390564328L;
	
	@ApiModelProperty(value = "第三方用户来源（1：标识微信登录，2：QQ，3：Sina微博，4：钉钉，5：FACEBOOK）,6: 微信小程序, 7：苹果 9:支付宝 必填 ,10:企业微信")
	@NotNull
	@Min(1)
	@Max(10)
	private Integer thirdType;
	
	@ApiModelProperty(value = "用户授权第三方登录后，第三方返回的授权码code(在跳转url中), 必填")
	private String code;
	
	@ApiModelProperty(value = "登录来源：（1.网站 2.应用 3.小程序）。当第三方用户来源有多个登录来源时使用，如微信，有app微信登录，微信小程序登录。与com.dtyunxi.yundt.cube.center.identity.api.dto.request#UserLoginReqDto无关联。选填")
	private Integer loginSource;
	
	@ApiModelProperty(value = "有效时间（秒）, 若之前已经绑定,则返回认证中心生成的Token,此时需传validTime")
	private Integer validTime;

    @ApiModelProperty(value = "配置级别：1 租户级别 2 应用级别, 选填")
    private Integer configLevel;

	@ApiModelProperty(value = "客户端获取的identityToken, 苹果登录时必填")
    private String identityToken;
    
	@ApiModelProperty(value = "账号域")
	private String domain;


	public Integer getThirdType() {
		return thirdType;
	}

	public void setThirdType(Integer thirdType) {
		this.thirdType = thirdType;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Integer getLoginSource() {
		return loginSource;
	}

	public void setLoginSource(Integer loginSource) {
		this.loginSource = loginSource;
	}

	public Integer getValidTime() {
		return validTime;
	}

	public void setValidTime(Integer validTime) {
		this.validTime = validTime;
	}

    public Integer getConfigLevel() {
        return configLevel;
    }

    public void setConfigLevel(Integer configLevel) {
        this.configLevel = configLevel;
    }

	public String getIdentityToken() {
		return identityToken;
	}

	public void setIdentityToken(String identityToken) {
		this.identityToken = identityToken;
	}
		
	public String getDomain() {
		return domain;
	}

	public void setDomain(String domain) {
		this.domain = domain;
	}

}
