package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(value = "BindingReqDto",description = "第三方平台账号信息")
public class BindingReqDto {
    /**
     * 登陆类型
     */
    @ApiModelProperty(value = "第三方类型（1：微信，2：QQ，3：Sina微博, 必填）", required = true)
    @Min(1)
    @Max(6)
    @NotNull
    private Integer thirdType;

    /**
     * 第三方平台的用户openId
     */
    @ApiModelProperty(value = "第三方平台的用户openId, 必填")
    private String openId;

    /**
     * 账户状态
     */
    @ApiModelProperty(value = "状态, 1启用2禁用,默认为1")
    private Integer status;

    public Integer getThirdType() {
        return thirdType;
    }

    public void setThirdType(Integer thirdType) {
        this.thirdType = thirdType;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
