package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 登录记录(查询)请求Dto
 * @author 青竹
 */
@ApiModel(value = "LoginLogReqDto", description = "登录记录(查询)请求Dto")
public class LoginLogReqDto extends RequestDto {
    private static final long serialVersionUID = 8775043487708445457L;
    @NotNull
    @ApiModelProperty(value = "开始时间:格式 yyyy-MM-dd HH:mm:ss", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date beginTime;

    @NotNull
    @ApiModelProperty(value = "结束时间:格式 yyyy-MM-dd HH:mm:ss", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty(value = "用户名")
    private String userName;

    @ApiModelProperty(value = "登录Ip")
    private String clientIp;

    @ApiModelProperty(value = "登录状态：1登录成功 2退出登录")
    private Integer status;

    @NotNull
    @ApiModelProperty(value = "角色编码，查询多个角色请使用英文逗号分隔",required = true)
    private String roleCode;

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }
}
