/**
 * @(#) LoginReqDto.java 1.0 2019-11-08
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;

/**
 * 登录请求dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "LoginReqDto", description = "登录DTO")
public class LoginReqDto {
    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名，必填")
    @NotBlank
    private String userName;

    /**
     * 密码
     */
    @NotBlank
    @ApiModelProperty(value = "密码，必填")
    private String password;

    /**
     * 图形验证码
     */
    @ApiModelProperty(value = "图形验证码，loginType=6时必填")
    private String code;

    /**
     * 验证码唯一id
     */
    @ApiModelProperty(value = "验证码唯一id，loginType=6时必填")
    private String uniqueId;

    /**
     * 登录方式
     */
    @ApiModelProperty(value = "登陆方式：(0,手机号 + 密码> 用户名 + 密码> 邮箱 + 密码，默认方式),（6,用户名+加密码+验证码），（7,用户名+加密码+滑块验证码）")
    private Integer loginType;

    /**
     * 滑块验证码，X轴
     */
    @ApiModelProperty(value = "滑块验证码X轴，loginType=7时必填")
    private Integer slideX;

    /**
     * 滑块验证码唯一id
     */
    @ApiModelProperty(value = "滑块验证码唯一id，loginType=7时必填")
    private String slideUniqueId;

    /**
     * 登录来源
     */
    @ApiModelProperty(name="loginSource",value = "登陆来源, 不同登陆来源不会互踢，同一登录来源会互踢(默认)，如果要控制同一登录来源不互踢，可配置业务参数登录时同一登录来源是否互踢的值为false，选填。")
    private String loginSource;

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Integer getLoginType() {
        return loginType;
    }

    public void setLoginType(Integer loginType) {
        this.loginType = loginType;
    }

    public Integer getSlideX() {
        return slideX;
    }

    public void setSlideX(Integer slideX) {
        this.slideX = slideX;
    }

    public String getSlideUniqueId() {
        return slideUniqueId;
    }

    public void setSlideUniqueId(String slideUniqueId) {
        this.slideUniqueId = slideUniqueId;
    }

    public String getLoginSource() {
        return loginSource;
    }

    public void setLoginSource(String loginSource) {
        this.loginSource = loginSource;
    }
}
