package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * Token刷新请求Dto
 */
@ApiModel(value = "RefreshTokenReqDto", description = "Token刷新请求Dto")
public class RefreshTokenReqDto extends RequestDto {

    private static final long serialVersionUID = -3046469021767878216L;

    /**
     * 旧Token
     */
    @ApiModelProperty(value = "旧Token")
    @NotEmpty
    private String token;

    /**
     * token 有效时间
     */
    @ApiModelProperty(value = "期望生成的新token 有效时间（秒）")
    private Integer tokenValidTime;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Integer getTokenValidTime() {
        return tokenValidTime;
    }

    public void setTokenValidTime(Integer tokenValidTime) {
        this.tokenValidTime = tokenValidTime;
    }
}
