/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

/**
 * 登陆用户传输dto
 * 
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "UserLoginReqDto", description = "登陆用户Dto")
public class UserLoginReqDto extends RequestDto {
	private static final long serialVersionUID = -596882374227258344L;
	
	/**
	 * 登陆类型
	 *
	 * + "登陆方式：(0,手机号 + 密码> 用户名 + 密码> 邮箱 + 密码),(1,用户名+密码),（2，手机+密码），" + "（3，手机+短信验证码），（4，邮箱+密码），（5,身份证+加密码），" +
	 * "（6,用户名+加密码+验证码）,（7,用户名+加密码+滑块验证码）
	 */
	@ApiModelProperty(value = "登陆方式(必填)：(0,手机号 + 密码> 用户名 + 密码> 邮箱 + 密码),(1,用户名+密码)（2，手机+密码），（3，手机+验证码），（4，邮箱+密码），（5,身份证+加密码），（6,用户名+加密码+验证码），（7,用户名+加密码+滑块验证码）", required = true)
	@Min(0)
	@Max(99)
	private Integer loginType;
	
	/**
	 * 登陆ip地址
	 */
	@ApiModelProperty(value = "登陆ip地址, 选填")
	private String loginIp;

	/**
	 * 用户名
	 */
	@ApiModelProperty(value = "用户名, 根据登录方式选填")
	private String userName;
	
	/**
	 * 邮箱
	 */
	@ApiModelProperty(value = "邮箱, 根据登录方式选填")
	private String email;
	
	/**
	 * 密码
	 */
	@ApiModelProperty(value = "密码, 根据登录方式选填")
	private String password;
	
	/**
	 * 手机号码
	 */
	@ApiModelProperty(value = "手机号码, 根据登录方式选填")
	private String phone;
	
	/**
	 * 证件号码
	 */
	@ApiModelProperty(value = "身份证号码, 根据登录方式选填")
	private String idCode;

	/**
	 * 短信验证码
	 */
	@ApiModelProperty(value = "短信验证码, 根据登录方式选填")
	private String checkCode;
	
	/**
	 * 短信验证码唯一id
	 */
	@ApiModelProperty(value = "短信验证码唯一id, 根据登录方式选填")
	private String checkCodeUniqueId;
	
	/**
	 * 图形验证码
	 */
	@ApiModelProperty(value = "图形验证码, 根据登录方式选填")
	private String code;
	
	/**
	 * 验证码唯一id
	 */
	@ApiModelProperty(value = "图形验证码唯一id, 根据登录方式选填")
	private String uniqueId;

	/**
	 * 滑块验证码，X轴
	 */
	@ApiModelProperty(value = "滑块验证码X轴，loginType=7时必填")
	private Integer slideX;

	/**
	 * 滑块验证码唯一id
	 */
	@ApiModelProperty(value = "滑块验证码唯一id，loginType=7时必填")
	private String slideUniqueId;
	
	/**
	 * token 有效时间
	 */
	@ApiModelProperty(value = "token 有效时间（秒）, 必填")
	private Integer tokenValidTime;

	/**
	 * 登录来源
	 */
	@ApiModelProperty(name="loginSource",value = "登陆来源, 不同登陆来源不会互踢，同一登录来源也不会互踢(默认)，如果要控制同一登录来源互踢，可配置yundt.cube.center.identity.shareTokenWithSameLoginSource:false，选填。")
	private String loginSource;
	/**
	 * 登陆渠道
	 */
	@ApiModelProperty(name="loginChannel",value = "登陆渠道, 不同登陆渠道会互踢，选填(暂未启用)")
	private String loginChannel;

	/**
	 * app Key
	 */
	@ApiModelProperty(value = "appKey(租户开通应用时业务中台生成的APPKey,申请SSO令牌必传)")
	private String appKey;

	/**
	 * app 签名
	 */
	@ApiModelProperty(value = "app签名,基于租户开通应用时业务中台分配APPSecret,使用com.dtyunxi.cube.utils.TokenUtil#generate方法生成(应用根据需要指定过期时间),(申请SSO令牌必传)")
	private String appSign;
	
	/**
	 * 设备id
	 */
	@ApiModelProperty(value = "设备id, 选填")
	private String deviceId;

	/**
	 * 扩展字段
	 */
	@ApiModelProperty(value = "扩展字段")
	private String extension;
	
	/**
	 * 扩展字段
	 */
	@ApiModelProperty(value = "扩展字段")
	private String extension2;

	/**
	 * 扩展字段
	 */
	@ApiModelProperty(value = "扩展字段")
	private String extension3;
	
	/**
	 * 扩展字段
	 */
	@ApiModelProperty(value = "扩展字段")
	private String extension4;

	public String toQueryFilter() {
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("tenantId", this.getTenantId());
		jsonObject.put("instanceId", this.getInstanceId());
		jsonObject.put("extFields", this.getExtFields());
		return jsonObject.toJSONString();
	}

	public String getLoginChannel() {
		return loginChannel;
	}

	public void setLoginChannel(String loginChannel) {
		this.loginChannel = loginChannel;
	}

	public Integer getTokenValidTime() {
		return tokenValidTime;
	}

	public void setTokenValidTime(Integer tokenValidTime) {
		this.tokenValidTime = tokenValidTime;
	}

	public String getLoginSource() {
		return loginSource;
	}

	public void setLoginSource(String loginSource) {
		this.loginSource = loginSource;
	}

	public String getCheckCodeUniqueId() {
		return checkCodeUniqueId;
	}

	public void setCheckCodeUniqueId(String checkCodeUniqueId) {
		this.checkCodeUniqueId = checkCodeUniqueId;
	}

	public String getUniqueId() {
		return uniqueId;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getIdCode() {
		return idCode;
	}

	public void setIdCode(String idCode) {
		this.idCode = idCode;
	}

	public String getCheckCode() {
		return checkCode;
	}

	public void setCheckCode(String checkCode) {
		this.checkCode = checkCode;
	}

	public Integer getLoginType() {
		return loginType;
	}

	public void setLoginType(Integer loginType) {
		this.loginType = loginType;
	}

	public String getLoginIp() {
		return loginIp;
	}

	public void setLoginIp(String loginIp) {
		this.loginIp = loginIp;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getAppKey() {
		return appKey;
	}

	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}

	public String getAppSign() {
		return appSign;
	}

	public void setAppSign(String appSign) {
		this.appSign = appSign;
	}

	public String getDeviceId() {
		return deviceId;
	}

	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getExtension() {
		return extension;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	public String getExtension2() {
		return extension2;
	}

	public void setExtension2(String extension2) {
		this.extension2 = extension2;
	}

	public String getExtension3() {
		return extension3;
	}

	public void setExtension3(String extension3) {
		this.extension3 = extension3;
	}

	public String getExtension4() {
		return extension4;
	}

	public void setExtension4(String extension4) {
		this.extension4 = extension4;
	}

	public Integer getSlideX() {
		return slideX;
	}

	public void setSlideX(Integer slideX) {
		this.slideX = slideX;
	}

	public String getSlideUniqueId() {
		return slideUniqueId;
	}

	public void setSlideUniqueId(String slideUniqueId) {
		this.slideUniqueId = slideUniqueId;
	}
}