/*
 * @(#)UserReqDto.java 1.0 2018-08-22
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.util.Date;

/**
 * 注册请求实体 Dto
 *
 * @author 项羽
 * @since 2.0.0
 */
@ApiModel(value = "UserReqDto", description = "注册Dto")
public class UserReqDto extends BaseReqDto {

    private static final long serialVersionUID = -5324816712440464348L;

    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名, 根据注册方式选填")
    private String userName;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码 加密：需要用MD5加密, 根据注册方式选填")
    private String password;

    /**
     * 确认密码
     */
    @ApiModelProperty(value = "确认密码 加密：需要用MD5加密, 选填")
    private String confirmPassword;

    /**
     * 盐值
     */
    @ApiModelProperty(value = "盐值, 选填")
    private String salt;

	/**
	 * 验证码
	 */
	@ApiModelProperty(value = "验证码, 根据注册方式选填")
	private String verifyCode;

    /**
     * 邮箱
     */
    @Email
    @ApiModelProperty(value = "邮箱, 根据注册方式选填")
    private String email;

    /**
     * 手机
     */
    @ApiModelProperty(value = "手机, 根据注册方式选填")
    private String phone;

    /**
     * 用户类型
     */
    @ApiModelProperty(value = "用户类型, 潜客用户类型为0 会员用户类型是1, 选填")
    private Integer userType;

    /**
     * 其他用户参数json字符串
     */
    @ApiModelProperty(value = "其他用户参数json字符串, 选填")
    private String jsonParam;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码, 选填")
    private String channelCode;
    
	/**
	 * 如果有请求发送了验证码需要再注册中验证有效性需要传发送验证码成功后返回的字符串即是uniqueId
	 */
	@ApiModelProperty(value = "传发送验证码成功后返回的字符串即是uniqueId")
	private String uniqueId;


    /**
     * 1手机+验证码2手机+验证码+密码3邮箱注册+密码+验证码激活4用户名+密码
     */
    @Min(1)
    @Max(4)
    @ApiModelProperty(value = "1手机+验证码2手机+验证码+密码3邮箱注册+密码+验证码激活4用户名+密码, 必传")
    private Integer registerType;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称, 选填")
    private String nickName;

    /**
     * 头像
     */
    @ApiModelProperty(value = "头像, 选填")
    private String avatar;

    @ApiModelProperty(value = "注册时间, 选填")
    private Date registerTime;

    @ApiModelProperty(value = "1启用2禁用, 默认为1")
    private Integer status;

    //TODO 用户中心userDto 的扩展参数：存放其他业务参数
    @ApiModelProperty(value = "扩展参数，格式为JSON", allowEmptyValue = true)
    private String extraParams;

    /**
     * 账号有效期类型(1：正常账号、2：临时账号，默认为1)
     */
    @ApiModelProperty(value = "账号有效期类型(1：正常账号、2：临时账号，默认为1)")
    private Integer validType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirmPassword() {
        return confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getVerifyCode() {
        return verifyCode;
    }

    public void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getJsonParam() {
        return jsonParam;
    }

    public void setJsonParam(String jsonParam) {
        this.jsonParam = jsonParam;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Integer getRegisterType() {
        return registerType;
    }

    public void setRegisterType(Integer registerType) {
        this.registerType = registerType;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getExtraParams() {
        return extraParams;
    }

    public void setExtraParams(String extraParams) {
        this.extraParams = extraParams;
    }

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Integer getValidType() {
        return validType;
    }

    public void setValidType(Integer validType) {
        this.validType = validType;
    }
}
