/**
 * @(#) AppSecretRespDto.java 1.0 2019-01-21
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author 刘备
 * @since 1.0.0
 */
@ApiModel(value = "AppSecretRespDto", description = "第三方开发者配置")
public class AppSecretRespDto extends BaseVo {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "第三方appId")
    private String keyAppId;

    @ApiModelProperty(value = "第三方appSecret")
    private String keyAppSecret;

    @ApiModelProperty(value = "第三方类型：1 微信， 2 QQ， 3 新浪， 4 支付宝， 5 钉钉")
    private Integer thirdparyType;

    @ApiModelProperty(value = "状态：1可用   2禁用")
    private Integer status;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "第三方的app配置,json格式存储的第三方开发者其他信息")
    private String keyAppConfig;

    @ApiModelProperty(value = "实例ID")
    private Long instanceId;

    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    public String getKeyAppConfig() {
        return keyAppConfig;
    }

    public void setKeyAppConfig(String keyAppConfig) {
        this.keyAppConfig = keyAppConfig;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getKeyAppId() {
        return keyAppId;
    }

    public void setKeyAppId(String keyAppId) {
        this.keyAppId = keyAppId;
    }

    public String getKeyAppSecret() {
        return keyAppSecret;
    }

    public void setKeyAppSecret(String keyAppSecret) {
        this.keyAppSecret = keyAppSecret;
    }

    public Integer getThirdparyType() {
        return thirdparyType;
    }

    public void setThirdparyType(Integer thirdparyType) {
        this.thirdparyType = thirdparyType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}