package com.dtyunxi.yundt.cube.center.identity.api.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 登录记录返回Dto
 * @author 青竹
 */
@ApiModel(value = "AppSecretRespDto", description = "登录记录返回Dto")
public class LoginLogRespDto extends RequestDto {

    @ApiModelProperty(value = "登录时间")
    private Date logTime;

    @ApiModelProperty(value = "用户名")
    private String userName;

    @ApiModelProperty(value = "用户Id")
    private Long userId;

    @ApiModelProperty(value = "用户类型")
    private String userType;

    @ApiModelProperty(value = "应用Id")
    private Long applicationId;

    @ApiModelProperty(value = "登录Ip")
    private String clientIp;

    @ApiModelProperty(value = "登录状态：1登录成功 2退出登录")
    private Integer status;

    @ApiModelProperty(value = "登录凭证即token")
    private String authKey;

    @ApiModelProperty(value = "备注信息")
    private String remark;

    @ApiModelProperty(value = "设备Id")
    private String deviceId;

    @ApiModelProperty(value = "角色编码串，多个用 , 分隔")
    private String roleCodeStr;

    @ApiModelProperty(value = "登录时间")
    private String loginTime;

    @ApiModelProperty(value = "登出时间")
    private String logoutTime;

    @ApiModelProperty(value = "租户名称")
    private String tenantName;

    @ApiModelProperty(value = "应用名称")
    private String appInstanceName;

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getAppInstanceName() {
        return appInstanceName;
    }

    public void setAppInstanceName(String appInstanceName) {
        this.appInstanceName = appInstanceName;
    }

    public String getLoginTime() {
        return loginTime;
    }

    public void setLoginTime(String loginTime) {
        this.loginTime = loginTime;
    }

    public String getLogoutTime() {
        return logoutTime;
    }

    public void setLogoutTime(String logoutTime) {
        this.logoutTime = logoutTime;
    }

    public Date getLogTime() {
        return logTime;
    }

    public void setLogTime(Date logTime) {
        this.logTime = logTime;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public Long getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getAuthKey() {
        return authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getRoleCodeStr() {
        return roleCodeStr;
    }

    public void setRoleCodeStr(String roleCodeStr) {
        this.roleCodeStr = roleCodeStr;
    }
}
