package com.dtyunxi.yundt.cube.center.identity.api.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * Token刷新响应Dto
 */
@ApiModel(value = "RefreshTokenRespDto", description = "Token刷新响应Dto")
public class RefreshTokenRespDto implements Serializable {

    private static final long serialVersionUID = 897266271261832965L;

    /**
     * 新Token
     */
    @ApiModelProperty(value = "新Token，如果旧token过期时间大于设置的token刷新时间，返回旧token")
    private String token;

    /**
     * token 有效时间
     */
    @ApiModelProperty(value = "当前token 有效时间（秒）")
    private Integer tokenValidTime;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Integer getTokenValidTime() {
        return tokenValidTime;
    }

    public void setTokenValidTime(Integer tokenValidTime) {
        this.tokenValidTime = tokenValidTime;
    }
}
