/**
 * @(#) SsoRespDto.java 1.0 2020-04-07
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.identity.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * BOC统一登录响应dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "SsoRespDto", description = "BOC统一登录响应dto")
public class SsoRespDto extends LoginRespDto{

    @ApiModelProperty(value = "单系统角色是否自动跳转，true:自动跳转；false:不自动跳转")
    private Boolean autoRedirect;

    @ApiModelProperty(value = "用户授权访问的应用列表")
    private List<SsoAppInstanceRespDto> appInstanceRespDtoList;

    public Boolean getAutoRedirect() {
        return autoRedirect;
    }

    public void setAutoRedirect(Boolean autoRedirect) {
        this.autoRedirect = autoRedirect;
    }

    public List<SsoAppInstanceRespDto> getAppInstanceRespDtoList() {
        return appInstanceRespDtoList;
    }

    public void setAppInstanceRespDtoList(List<SsoAppInstanceRespDto> appInstanceRespDtoList) {
        this.appInstanceRespDtoList = appInstanceRespDtoList;
    }
}
