/*
 * @(#)ThirdUserInfoRespDto.java 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 第三方登录接口resp返回信息
 * 
 * @author 项羽
 * @version 2.0
 */
@ApiModel(value = "ThirdLoginRespDto", description = "第三方登陆返回结果")
public class ThirdLoginRespDto extends BaseVo {

	private static final long serialVersionUID = -344637858374650017L;
	@ApiModelProperty(value = "用户ID")
	private Long userId;
	@ApiModelProperty(value = "结果信息，第三方登录认证成功后得到认证中心生成的token")
	private String token;
	@ApiModelProperty(value = "第三方生产的token(绑定时候需要用到)")
	private String thirdToken;
	@ApiModelProperty(value = "第三方生产的openId(绑定时候需要用到)")
	private String openId;
	@ApiModelProperty(value = "第三方生产的sessionKey，会话密钥")
	private String sessionKey;
	@ApiModelProperty(value = "第三方生产的手机号(企业微信绑定时候需要用到)")
	private String phone;
	public String getOpenId() {
		return openId;
	}

	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getToken() {
		return token;
	}

	public String getThirdToken() {
		return thirdToken;
	}

	public void setThirdToken(String thirdToken) {
		this.thirdToken = thirdToken;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getSessionKey() {
		return sessionKey;
	}

	public void setSessionKey(String sessionKey) {
		this.sessionKey = sessionKey;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}
}
