/**
 * @(#)IdentityExceptionCode.java 1.0 2018-08-10
 * <p>
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.exception;

import com.dtyunxi.cube.commons.exceptions.BizException;

/**
 *      描述注册过程中出现的异常情况
 *
 * @author 项  羽
 * @since 0.6.0
 */
public enum IdentityExceptionCode {
    EEEE("0", "操作成功"),
    FAIL("1", "操作失败"),
    VERIFYCODE_CREATE_ERROR("10018", "获取图形验证码异常"),
    PASSWORD_CONFIRM_ERROR("10019", "两次密码输入不一致"),
    REGISTER_FAIL_ERROR("10020", "注册失败，请重试"),
    PASSWORD_IS_REQUIRED("10001", "密码不能为空"),
    VERIFYCODE_CONFIRM_ERROR("10002", "验证码错误或已过期"),
    SMS_VERIFYCODE_CONFIRM_ERROR("10003", "短信验证码错误，请重新获取"),
    EMPTY_PHONEOREMAIL_ERROR("10004", "验证码发送错误，手机或者邮箱为空"),
    EMPTY_EMAILPARAM_ERROR("10007", "参数错误，邮箱为空"),
    EMPTY_PHONEPARAM_ERROR("10008", "参数错误，手机为空"),
    EMPTY_PHONEVERIFYPARAM_ERROR("10006", "参数错误，验证码不可以为空"),
    EMPTY_USERNAMEPARAM_ERROR("10009", "参数错误，用户名为空"),
    EMPTY_REGISTERPARAM_ERROR("10011", "参数错误，注册类型不能为空，且目前只支持1-4的范围（1手机+验证码;2手机+验证码+密码;3邮箱注册+密码+验证码激活;4用户名+密码;）"),
    EMPTY_PARAM_ERROR("10010", "参数错误，请检查注册参数"),
    EMPTY_OPENID_UNIONID_ERROR("10027", "参数错误，openId和unionId必须提供一个，不能同时为空"),
    UNSUPPORT_THIRD_TYPE("10028", "参数错误，第三方登录类型未支持"),
    EMPTY_USER_TYPE("10013", "新用户用户类型不能为空"),
    BINDING_FAIL("10015", "绑定失败"),
    BINDING_FAIL_USER("10016", "绑定失败,已经存在绑定用户"),
    THIRD_TOKEN_NO_VALID("10017", "绑定失败，第三方token失效"),
    CODE_EXPIRE("10021", "授权码已过期"),
    EMPTY_STATE_PARAM_ERROR("10022", "从认证中心获取<QQ登录授权码code申请的url>时，state通过扩展参数extFields提供给认证中心，state不能为空"),
    EMPTY_REDIRECTURI_PARAM_ERROR("10023", "通过认证中心申请获取第三方access_token时，redirectUri通过扩展参数extFields提供给认证中心，redirectUri不能为空"),
    EMPTY_RESP_BODY("10024", "第三方调用失败，响应body为空"),
    USERNAME_FORMAT_ERROR("10025", "用户账号格式非法，不能是纯数字或者邮箱，必须由字母、数字、下划线、-、句点.组成"),
    EMPTY_ACCESSTOKEN_PARAM_ERROR("10026", "通过认证中心申请sns_token时候，access_token通过扩展参数extFields提供给认证中心，access_token能为空"),
    OPEN_ID_ERROR("10027","参数错误。OpenId异常"),
    VERIFYCODE_PHONE_ERROR("10012", "注册手机必须是发送验证码手机"),
    EXIST_FAIL("3003", "注册所用的账号信息已存在"),

    VERIFYCODE_EMAIL_ERROR("10013", "注册邮箱必须是发送验证码邮箱"),

    PASSWORD_NO_VALID("4001", "密码错误"),
    CODE_NO_VALID("4002", "短信验证码错误"),

    USER_NO_EXIST("4003", "用户不存在"),
    USER_NO_AGREE_LOGIN("4004", "用户未开启这种登陆方式"),
    LOGIN_ERROR_OVER_LIMIT("4005", "登录密码错误次数过多，或者验证码错误"),
    IMAGE_CODE_NO_VALID("4006", "图形验证码无效"),
    JSONPARAM_CONFIRM_ERROR("4007", "jsonParam扩展参数必须为json字符串"),
    TOKEN_CODE_NO_VALID("4008", "token无效或超时，验证失败"),
    USER_DISABLE("4009", "用户被禁用了"),
    IMAGE_CODE_PARAM_ERROR("4011", "图形验证码参数错误"),
    PHONE_CODE_PARAM_ERROR("4012", "手机验证码参数错误"),
    USER_NEED_PHONE_BINDED("4013", "用户未关联手机,需要关联后才能进行对应操作"),
    USER_ILLEGAL("4014", "用户不合法"),
    USER_NO_ROLE_ACCESS("4015", "未获得任何授权"),
    USER_ACCOUNT_OVERDUE("4016", "用户账号已过期"),
    USER_FREEZE("4017", "用户账号已冻结"),
    APP_SECRET_NOT_EXISTS("10026", "缺少第三方开发者配置"),
    APP_SECRET_EXISTS("10027", "配置已存在，不能重复配置"),
    TENANT_NO_EXIST_BY_TENANT_ID("10028", "根据租户Id找不到租户信息"),
    APP_INSTANCE_NO_EXIST_BY_INSTANCE_ID("10029", "根据实例Id找不到实例信息"),
    IO_EXCEPTON("10030", "IO异常"),
    Login_SEND_MESSAGE_ERROR("10031", "mq发送异常"),
    USERNAME_VERIFY_FAIL("10032", "用户账号格式非法，用户名长度要大于8个字符"),
    PASSWORD_VERIFY_FAIL("10033", "用户密码格式非法，密码需要包含字母，并且长度大于8位"),
    TENANT_NOT_EXIST("10034", "登陆端非法"),
    LOGIN_FAIL("10035", "登录认证失败"),
    USER_NAME_OR_PASSWORD_ERROR("10036", "用户名或密码错误"),
    GET_USER_INFO_FAIL("10037", "获取用户信息失败"),
    LDAP_CONFIG_NOT_EXISTS("10038", "缺少LADP配置信息"),
    GET_ACCESS_TOKEN_ERROR("10039", "获取AccessToken异常，请检测AppId和AppSecret是否配置正确"),
    GET_PERSISTENCE_CODE_ERROR("10040", "获取持久授权码异常"),
    GET_SNS_TOKEN_ERROR("10041", "获取 sns token 异常"),
    USER_ACCOUNT_NO_EXIST("10042", "账号不存在，请联系管理员找回");


    private final String code;

    private final String msg;

    private IdentityExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;

    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }

    public static void throwParamException(IdentityExceptionCode identityExceptionCode) {
        throwBizException(identityExceptionCode);
    }

    public static void throwBizException(IdentityExceptionCode identityExceptionCode) {
        throw new BizException(identityExceptionCode.getCode(), identityExceptionCode.getMsg());
    }

    public static void throwBizException(String code, String msg) {
        throw new BizException(code, msg);
    }

}
