/**
 * @(#) DictionaryQueryApi.java 1.0 2019-06-24
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.DictionaryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 常量配置服务
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"认证中心：常量配置服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-query-IDictionaryQueryApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v2/dictionary", url = "${yundt.cube.center.identity.api:}")
public interface IDictionaryQueryApi {

    /**
     * 根据key查询常量配置
     *
     * @param keys   常量配置key
     * @param filter 数据过滤
     * @return 常量配置数据
     */
    @GetMapping("/{keys}")
    @ApiOperation(value = "根据key查询常量配置", notes = "根据key查询常量配置,filter格式参考:{\"instanceId\":1,\"tenantId\":1}")
    RestResponse<List<DictionaryRespDto>> queryDictionaryByKey(@PathVariable("keys") String keys,
                                                               @RequestParam("filter") String filter);

    /**
     * 分页查询常量配置
     *
     * @param filter   数据过滤
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 常量配置分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页查询常量配置", notes = "分页查询常量配置,filter格式参考:{\"group\":\"Xxx\",\"key\":\"Xxx\"}\n" +
            "单次查询限额1000条\n")
    RestResponse<PageInfo<DictionaryRespDto>> queryDictionaryByPage(@RequestParam("filter") String filter,
                                                                    @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                    @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);
}
