/**
 * @(#) IRegisterQueryApi.java 1.0 2018-09-04
 * 
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.query;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import javax.validation.constraints.NotNull;

/**
 * 注册查询用户信息API
 * 
 * @author 项羽
 * @since 2.0.0
 */
@Api(tags = { "认证中心：注册服务" })
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-query-IRegisterQueryApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v2/user", url = "${yundt.cube.center.identity.api:}")
public interface IRegisterQueryApi {
	/**
	 * 检查注册账号是否存在
	 * 
	 * @param account
	 *            用户名/手机号/其它唯一
	 * @param instanceId 实例id
	 * @return boolean
	 */
	@GetMapping(value = "/{account}/{instanceId}/isunique", produces = "application/json")
	@ApiOperation(value = "检验用户账号是否已经存在", notes = "认证中心用户注册调用用户中心接口判断用户是否存在，入参注册用户唯一标识account，检查用户中心是否存在此唯一标识返回true or false")
	@ApiImplicitParams({
			@ApiImplicitParam(paramType = "path", name = "account", dataType = "String", required = true, value = "用户名/手机号/邮箱/其它唯一", defaultValue = ""),
			@ApiImplicitParam(paramType = "path", name = "instanceId", dataType = "String", required = true, value = "实例id", defaultValue = "") })
	RestResponse<Boolean> checkAccountExist(@NotNull @PathVariable("account") String account,
			@PathVariable("instanceId") String instanceId);
}
