/**
 * @(#) DictionaryApi.java 1.0 2019-06-24
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.v3;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.DictionaryReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 常量配置服务
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"认证中心：常量配置服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-v3-IDictionaryApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v3/dictionary", url = "${yundt.cube.center.identity.api:}")
public interface IDictionaryApi {

    /**
     * 新增常量配置
     *
     * @param dictionaryReqDto 常量配置请求Dto
     * @return 操作结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增常量配置", notes = "新增常量配置,原先在配置中心设置的配置项，例如token失效时间，改为数据表配置，支持按照租户/实例配置。\n")
    RestResponse<Void> addDictionary(@RequestBody DictionaryReqDto dictionaryReqDto);

    /**
     * 修改常量配置
     *
     * @param dictionaryReqDto 常量配置修改请求Dto
     * @return 操作结果
     */
    @PutMapping("")
    @ApiOperation(value = "根据id修改常量配置", notes = "根据id修改常量配置")
    RestResponse<Void> modifyDictionary(@RequestBody DictionaryReqDto dictionaryReqDto);

    /**
     * 删除常量配置
     *
     * @param keys       要删除的key
     * @param instanceId 实例ID
     * @return 操作结果
     */
    @DeleteMapping("/by-keys")
    @ApiOperation(value = "根据key删除常量配置", notes = "根据key删除常量配置")
    RestResponse<Void> removeDictionary(@RequestParam("keys") String keys,
                                        @RequestParam("instanceId") Long instanceId);
}
