/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.v3;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.CheckTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Map;

/**
 * token管理api(登录创建api)
 *
 * @author 简树
 * @since 2.0.0
 */
@Api(tags = { "认证中心：token服务" })
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-v3-ITokenApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v3/user", url = "${yundt.cube.center.identity.api:}")
public interface ITokenApi {
	/**
	 * 检验token
	 *
	 * @param token
	 *            传入 token
	 * @return 返回检验结果
	 * @see com.dtyunxi.yundt.cube.center.identity.api.v3.ITokenApi#checkToken(CheckTokenReqDto)
	 */
	@Deprecated
	@GetMapping("/token/{token}/isvalid")
	@ApiOperation(value = "检验令牌有效性", notes = "检验令牌有效性")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "token", value = "令牌token", dataType = "string", paramType = "path", required = true, example = "/user/token/2222/isvalid") })
	RestResponse<Map<String, Object>> checkToken(@PathVariable("token") String token);

    /**
     * 检验token
     *
     * @param checkTokenReqDto
     *            传入 token
     * @return 返回检验结果
     */
    @GetMapping("/token/validate")
    @ApiOperation(value = "检验令牌有效性", notes = "检验令牌有效性")
    RestResponse<Map<String, Object>> checkToken(@SpringQueryMap @Valid CheckTokenReqDto checkTokenReqDto);

	/**
	 * 注销token
	 *
	 * @param userId
	 *            用户id
	 * @return 无
	 */
	@DeleteMapping("/{id}/token")
	@ApiOperation(value = "注销令牌", notes = " 注销令牌")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id", value = "用户id", dataType = "string", paramType = "path", required = true, example = "/v3/user/222/token") })
	RestResponse<Void> deleteToken(@PathVariable("id") String userId);


	/**
	 * 注销登录的令牌
	 * @param userId 用户id
     * @param loginSource 登录来源
	 */
	@DeleteMapping("/{id}/token/by-login-source/{loginSource}")
	@ApiOperation(value = "根据用户和登录来源注销令牌", notes = "根据用户和登录来源注销令牌")
	@ApiImplicitParams({
			@ApiImplicitParam(name="id",value="用户id",dataType="string", paramType = "path",required = true),
			@ApiImplicitParam(name="loginSource",value="登录来源",dataType="string", paramType = "path",required = true)
	})
	RestResponse<Void> deleteLoginToken(@PathVariable("id") String userId, @PathVariable("loginSource") String loginSource);

	/**
	 * 申请令牌（支持单点登录）
	 *
	 * @param user
	 *            登录用户信息
	 * @return 返回认证中心token
	 */
	@PostMapping("/token")
	@ApiOperation(value = "申请令牌", notes = "创建token,当登录错误次数过多时需要输入验证码，可以用返回结果的flag来知道是否需要输入验证码。重新获取验证可以调用：验证码发送和校验服务-》发送生成的图片验证码信息 重新获取验证码")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "user", value = "用户登录参数", dataType = "UserLoginReqDto", paramType = "body", example = "/11213213/user/222/token") })
	RestResponse<TokenRespDto> createToken(@Valid @RequestBody UserLoginReqDto user);

	/**
	 * SSO申请令牌
	 * @param user 登录用户信息
	 * @return
	 * @see com.dtyunxi.yundt.cube.center.identity.api.v3.ITokenApi#createToken(UserLoginReqDto)
	 */
	@Deprecated
	@PostMapping("/sso/token")
	@ApiOperation(value = "SSO申请令牌", notes = "注销SSO令牌,当用户申请一次token后,在其他关联应用中无需再次登录\n" +
			"创建token,当登录错误次数过多时需要输入验证码，可以用返回结果的flag来知道是否需要输入验证码。重新获取验证可以调用：验证码发送和校验服务-》发送生成的图片验证码信息 重新获取验证码")
	@ApiImplicitParams({
			@ApiImplicitParam(name="user",value="用户登录参数",dataType="UserLoginReqDto", paramType = "body")
	})
	RestResponse<TokenRespDto> createSsoToken(@Valid @RequestBody UserLoginReqDto user);

	/**
	 * 注销SSO令牌
	 * @param appKey appKey
	 * @param token token
	 * @see com.dtyunxi.yundt.cube.center.identity.api.v3.ITokenApi#deleteLoginToken(String, String)
	 */
	@Deprecated
	@DeleteMapping("/appkey/{appKey}/token/{token:.+}")
	@ApiOperation(value = "注销SSO令牌", notes = " 注销SSO令牌")
	@ApiImplicitParams({
			@ApiImplicitParam(name="appKey",value="appKey",dataType="string", paramType = "path",required = true),
			@ApiImplicitParam(name="token",value="token",dataType="string", paramType = "path",required = true)
	})
	RestResponse<Void> deleteSsoToken(@PathVariable("appKey") String appKey, @PathVariable("token") String token);

	/**
	 * 注销认证中心和idp登录
	 *
	 *
	 * @param token
	 * @param userId
	 *            用户id
	 * @return 无
	 */
	@DeleteMapping("/exit/user/{userId}/tenant_id/{tenantId}")
	@ApiOperation(value = "注销认证中心和idp令牌", notes = " 注销认证中心和idp令牌")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "userId", value = "用户id", dataType = "string") ,
			@ApiImplicitParam(name = "tenantId", value = "租户id", dataType = "string")})
	RestResponse<Void> exitLogin(@RequestHeader(name = "Access-Token") String token, @PathVariable("userId") String userId, @PathVariable("tenantId") Long tenantId);

}
