/**
 * @(#) AppSecretFilter.java 1.0 2019-01-21
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.vo;

/**
 * 开发者配置的过滤类
 *
 * @author 刘备
 * @since 1.0.0
 */
public class AppSecretFilter {

    /**
     * 第三方用户来源（1：标识微信登录，2：QQ，3：Sina微博）
     */
    private Integer thirdType;

    /**
     * 登录系统来源：1 开放平台（扫码） 2 微信公众号
     */
    private Integer loginSource;

    /**
     * 配置级别：1 租户级别 2 应用级别
     */
    private Integer configLevel;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 应用实例ID
     */
    private Long instanceId;

    public AppSecretFilter(){}

    public AppSecretFilter(Integer thirdType, Integer loginSource, Integer configLevel, Long tenantId, Long instanceId) {
        this.thirdType = thirdType;
        this.loginSource = loginSource;
        this.configLevel = configLevel;
        this.tenantId = tenantId;
        this.instanceId = instanceId;
    }

    public Integer getThirdType() {
        return thirdType;
    }

    public void setThirdType(Integer thirdType) {
        this.thirdType = thirdType;
    }

    public Integer getLoginSource() {
        return loginSource;
    }

    public void setLoginSource(Integer loginSource) {
        this.loginSource = loginSource;
    }

    public Integer getConfigLevel() {
        return configLevel;
    }

    public void setConfigLevel(Integer configLevel) {
        this.configLevel = configLevel;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}